/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest;

import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.rest.RestForestSpec;
import com.almworks.jira.structure.api.rest.RestSQuery;
import com.almworks.jira.structure.api.rest.RestTransformSpec;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.JiraUsers;
import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.HttpServletVariables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Immutable
public final class ForestSpec {
    @Nullable
    private final Long myStructureId;
    @Nullable
    private final Integer myVersion;
    @Nullable
    private final SQuery mySQuery;
    @Nullable
    private final String myClipboardSessionId;
    @Nullable
    private final String myUserKey;
    @Nullable
    private final List<Transformation> myTransformations;
    private final boolean mySecured;
    private final boolean mySkeleton;
    private final boolean myTitle;
    private int myHashCode;

    private ForestSpec(@Nullable Long structureId, @Nullable Integer version, @Nullable SQuery sQuery, @Nullable String clipboardSessionId, @Nullable List<Transformation> transformations, @Nullable String userKey, boolean secured, boolean skeleton, boolean title) {
        if (!$assertionsDisabled) {
            boolean[] blArray = new boolean[3];
            blArray[0] = structureId != null;
            blArray[1] = sQuery != null;
            boolean bl = blArray[2] = clipboardSessionId != null;
            if (!StructureUtil.onlyOneIsTrue(blArray)) {
                throw new AssertionError();
            }
        }
        assert (structureId != null || version == null);
        assert (!skeleton || version == null && sQuery == null && clipboardSessionId == null && transformations == null);
        this.myStructureId = structureId;
        this.myVersion = version;
        this.mySQuery = sQuery;
        this.myClipboardSessionId = clipboardSessionId;
        this.myTransformations = transformations != null && !transformations.isEmpty() ? Collections.unmodifiableList(transformations) : null;
        this.myUserKey = this.myStructureId == null || this.myTransformations != null || secured ? userKey : null;
        this.mySecured = secured;
        this.mySkeleton = skeleton;
        this.myTitle = title;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder builder(@Nullable ForestSpec spec) {
        return spec == null ? new Builder() : new Builder(spec);
    }

    @NotNull
    public static ForestSpec structure(long structureId) {
        return ForestSpec.structure(structureId, StructureAuth.getUser());
    }

    @NotNull
    public static ForestSpec structure(long structureId, @Nullable ApplicationUser user) {
        return ForestSpec.builder().setStructureId(structureId).setUserKey(JiraUsers.getKeyFor(user)).setSecured(true).build();
    }

    @NotNull
    public static ForestSpec unsecuredStructure(long structureId) {
        return ForestSpec.builder().setStructureId(structureId).build();
    }

    @NotNull
    public static ForestSpec skeleton(long structureId) {
        return ForestSpec.builder().setStructureId(structureId).setSkeleton(true).build();
    }

    @NotNull
    public static ForestSpec version(long structureId, int version) {
        return ForestSpec.builder().setStructureId(structureId).setVersion(version).build();
    }

    @NotNull
    public static ForestSpec sQuery(@NotNull String type, @NotNull String query) {
        return ForestSpec.builder().setSQuery(type, query).setSecured(true).setCurrentUserKey().build();
    }

    @NotNull
    public static ForestSpec clipboard(@NotNull String sessionId) {
        return ForestSpec.builder().setClipboardSessionId(sessionId).build();
    }

    @NotNull
    public ForestSpec secure(@Nullable String userKey) {
        return ForestSpec.builder(this).setUserKey(userKey).setSecured(true).build();
    }

    @NotNull
    public ForestSpec transform(@NotNull String module, @Nullable Map<String, Object> params) {
        assert (!this.mySkeleton);
        return ForestSpec.builder(this).setCurrentUserKey().addTransformation(module, params).setSkeleton(false).build();
    }

    public boolean isTransformed() {
        return this.myTransformations != null && !this.myTransformations.isEmpty();
    }

    @Nullable
    public ForestSpec getLastTransformedSpec() {
        if (!this.isTransformed()) {
            return null;
        }
        assert (this.myTransformations != null && !this.myTransformations.isEmpty());
        return ForestSpec.builder(this).setTransformations(this.myTransformations.subList(0, this.myTransformations.size() - 1)).setSkeleton(false).build();
    }

    @Nullable
    public Transformation getLastTransformation() {
        if (!this.isTransformed()) {
            return null;
        }
        assert (this.myTransformations != null && !this.myTransformations.isEmpty());
        return this.myTransformations.get(this.myTransformations.size() - 1);
    }

    @NotNull
    public ForestSpec getUntransformedSpec() {
        return this.isTransformed() ? ForestSpec.builder(this).setTransformations(null).build() : this;
    }

    @Nullable
    public Long getStructureId() {
        return this.myStructureId;
    }

    @Nullable
    public Integer getVersion() {
        return this.myVersion;
    }

    @Nullable
    public SQuery getSQuery() {
        return this.mySQuery;
    }

    @Nullable
    public String getClipboardSessionId() {
        return this.myClipboardSessionId;
    }

    @Nullable
    public String getUserKey() {
        return this.myUserKey;
    }

    @NotNull
    public List<Transformation> getTransformations() {
        return this.myTransformations == null ? Collections.emptyList() : this.myTransformations;
    }

    public boolean isSecured() {
        return this.mySecured;
    }

    public boolean isSkeleton() {
        return this.mySkeleton;
    }

    public boolean hasTitle() {
        return this.myTitle;
    }

    @NotNull
    public ForestSpec getUnsecured() {
        return this.isSecured() ? ForestSpec.builder(this).setSecured(false).build() : this;
    }

    @NotNull
    public ForestSpec withoutTitle() {
        if (!this.myTitle) {
            return this;
        }
        return ForestSpec.builder(this).setTitle(false).build();
    }

    @NotNull
    public ForestSpec withTitle() {
        if (this.myTitle) {
            return this;
        }
        return ForestSpec.builder(this).setTitle(true).build();
    }

    public <T> T accept(Visitor<T> visitor) throws StructureException {
        if (this.isSecured()) {
            return visitor.visitSecured(this);
        }
        if (this.isTransformed()) {
            return visitor.visitTransformation(this);
        }
        if (this.myStructureId != null) {
            return visitor.visitStructure(this);
        }
        if (this.mySQuery != null) {
            return visitor.visitSQuery(this);
        }
        if (this.myClipboardSessionId != null) {
            return visitor.visitClipboard(this);
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForestSpec that = (ForestSpec)o;
        return this.mySecured == that.mySecured && this.mySkeleton == that.mySkeleton && this.myTitle == that.myTitle && Objects.equals(this.myStructureId, that.myStructureId) && Objects.equals(this.myVersion, that.myVersion) && Objects.equals(this.mySQuery, that.mySQuery) && Objects.equals(this.myClipboardSessionId, that.myClipboardSessionId) && Objects.equals(this.myUserKey, that.myUserKey) && Objects.equals(this.myTransformations, that.myTransformations);
    }

    public int hashCode() {
        int hashCode = this.myHashCode;
        if (hashCode == 0) {
            hashCode = Objects.hash(this.myStructureId, this.myVersion, this.mySQuery, this.myClipboardSessionId, this.myUserKey, this.myTransformations, this.mySecured, this.mySkeleton, this.myTitle);
            if (hashCode == 0) {
                ++hashCode;
            }
            this.myHashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder r = new StringBuilder().append(StructureUtil.toJson(this.toRest()));
        if (this.mySkeleton) {
            r.append("(skeleton)");
        }
        if (this.myUserKey != null) {
            r.append("@").append(this.myUserKey);
        }
        if (this.mySecured) {
            r.append("(secure)");
        }
        return r.toString();
    }

    @NotNull
    public static ForestSpec fromRest(@Nullable RestForestSpec rfs) throws IllegalArgumentException {
        if (rfs == null) {
            throw new IllegalArgumentException("Forest spec is required");
        }
        Long structureId = rfs.structureId;
        Integer version = rfs.version;
        SQuery sQuery = SQuery.fromRest(rfs);
        String sessionId = null;
        boolean secured = true;
        boolean clipboard = "clipboard".equals(rfs.type);
        boolean title = rfs.title != null && rfs.title != false;
        if (!StructureUtil.onlyOneIsTrue(structureId != null, sQuery != null, clipboard)) {
            throw new IllegalArgumentException("Exactly one of structureId, sQuery, or clipboard must be present");
        }
        if (structureId == null && version != null) {
            throw new IllegalArgumentException("Version can be specified only with structureId");
        }
        if (title && structureId == null) {
            throw new IllegalArgumentException("Title item is supported only for structureId");
        }
        if (clipboard) {
            HttpServletVariables variables = (HttpServletVariables)ComponentAccessor.getComponent(HttpServletVariables.class);
            sessionId = (String)JiraComponents.withThreadContextClassLoaderOf(variables, () -> {
                HttpServletRequest request;
                HttpServletRequest httpServletRequest = request = variables != null ? variables.getHttpRequest() : null;
                if (request != null) {
                    return request.getSession().getId();
                }
                throw new IllegalStateException("Cannot obtain http session to create clipboard spec");
            });
            secured = false;
        }
        ArrayList<Transformation> transformations = null;
        if (rfs.transforms != null && !rfs.transforms.isEmpty()) {
            transformations = new ArrayList<Transformation>();
            for (RestTransformSpec rts : rfs.transforms) {
                transformations.add(new Transformation(rts.module, rts.params));
            }
        }
        return new ForestSpec(structureId, version, sQuery, sessionId, transformations, StructureAuth.getUserKey(), secured, false, title);
    }

    @NotNull
    public RestForestSpec toRest() {
        RestForestSpec rfs = new RestForestSpec();
        rfs.structureId = this.myStructureId;
        rfs.version = this.myVersion;
        if (this.mySQuery != null) {
            rfs.sQuery = new RestSQuery();
            rfs.sQuery.query = this.mySQuery.getQuery();
            rfs.sQuery.type = this.mySQuery.getType();
        }
        if (this.myClipboardSessionId != null) {
            rfs.type = "clipboard";
        }
        if (this.myTransformations != null) {
            rfs.transforms = new ArrayList<RestTransformSpec>(this.myTransformations.size());
            for (Transformation t : this.myTransformations) {
                RestTransformSpec rts = new RestTransformSpec();
                rts.module = t.getModule();
                rts.params = t.getParams();
                rfs.transforms.add(rts);
            }
        }
        if (this.myTitle) {
            rfs.title = true;
        }
        return rfs;
    }

    public static interface Visitor<T> {
        public T visitStructure(ForestSpec var1) throws StructureException;

        public T visitSQuery(ForestSpec var1) throws StructureException;

        public T visitTransformation(ForestSpec var1) throws StructureException;

        public T visitSecured(ForestSpec var1) throws StructureException;

        public T visitClipboard(ForestSpec var1) throws StructureException;
    }

    public static class Builder {
        private Long myStructureId;
        private Integer myVersion;
        private SQuery mySQuery;
        private String myClipboardSessionId;
        private String myUserKey;
        private List<Transformation> myTransformations;
        private boolean mySecured;
        private boolean mySkeleton;
        private boolean myTitle;

        public Builder() {
        }

        public Builder(@NotNull ForestSpec spec) {
            this.setStructureId(spec.getStructureId());
            this.setVersion(spec.getVersion());
            this.setSQuery(spec.getSQuery());
            this.setClipboardSessionId(spec.getClipboardSessionId());
            this.setUserKey(spec.getUserKey());
            this.setTransformations(spec.getTransformations());
            this.setSecured(spec.isSecured());
            this.setSkeleton(spec.isSkeleton());
            this.setTitle(spec.hasTitle());
        }

        @NotNull
        public Builder setStructureId(@Nullable Long structureId) {
            this.myStructureId = structureId;
            return this;
        }

        @NotNull
        public Builder setVersion(@Nullable Integer version) {
            this.myVersion = version;
            return this;
        }

        @NotNull
        public Builder setSQuery(@Nullable SQuery sQuery) {
            this.mySQuery = sQuery;
            return this;
        }

        @NotNull
        public Builder setSQuery(@NotNull String type, @NotNull String query) {
            return this.setSQuery(new SQuery(type, query));
        }

        @NotNull
        public Builder setClipboardSessionId(@Nullable String clipboardSessionId) {
            this.myClipboardSessionId = clipboardSessionId;
            return this;
        }

        @NotNull
        public Builder setUserKey(@Nullable String userKey) {
            this.myUserKey = userKey;
            return this;
        }

        @NotNull
        public Builder setCurrentUserKey() {
            this.myUserKey = StructureAuth.getUserKey();
            return this;
        }

        @NotNull
        public Builder setTransformations(@Nullable List<Transformation> transformations) {
            this.myTransformations = transformations == null || transformations.isEmpty() ? null : new ArrayList<Transformation>(transformations);
            return this;
        }

        @NotNull
        public Builder addTransformation(@NotNull Transformation transformation) {
            if (this.myTransformations == null) {
                this.myTransformations = new ArrayList<Transformation>();
            }
            this.myTransformations.add(transformation);
            return this;
        }

        @NotNull
        public Builder addTransformation(@NotNull String module, @Nullable Map<String, Object> params) {
            return this.addTransformation(new Transformation(module, params));
        }

        @NotNull
        public Builder setSecured(boolean secured) {
            this.mySecured = secured;
            return this;
        }

        @NotNull
        public Builder setSkeleton(boolean skeleton) {
            this.mySkeleton = skeleton;
            return this;
        }

        @NotNull
        public Builder setTitle(boolean title) {
            this.myTitle = title;
            return this;
        }

        @NotNull
        public ForestSpec build() {
            return new ForestSpec(this.myStructureId, this.myVersion, this.mySQuery, this.myClipboardSessionId, this.myTransformations, this.myUserKey, this.mySecured, this.mySkeleton, this.myTitle);
        }
    }

    public static final class Transformation {
        @NotNull
        private final String myModule;
        @Nullable
        private final Map<String, Object> myParams;

        public Transformation(@NotNull String module, @Nullable Map<String, Object> params) {
            this.myModule = module;
            this.myParams = params == null ? null : JsonMapUtil.copyParameters(params, false, true, false);
        }

        @NotNull
        public String getModule() {
            return this.myModule;
        }

        @Nullable
        public Map<String, Object> getParams() {
            return this.myParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transformation that = (Transformation)o;
            if (!this.myModule.equals(that.myModule)) {
                return false;
            }
            return !(this.myParams != null ? !this.myParams.equals(that.myParams) : that.myParams != null);
        }

        public int hashCode() {
            int result = this.myModule.hashCode();
            result = 31 * result + (this.myParams != null ? this.myParams.hashCode() : 0);
            return result;
        }
    }

    @PublicApi
    public static final class SQuery {
        public static final String TYPE_JQL = "jql";
        public static final String TYPE_TEXT = "text";
        public static final String TYPE_CQL = "cql";
        @NotNull
        private final String myType;
        @NotNull
        private final String myQuery;

        public SQuery(@NotNull String type, @NotNull String query) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null");
            }
            if (query == null) {
                throw new IllegalArgumentException("query cannot be null");
            }
            this.myQuery = query;
            this.myType = type;
        }

        @NotNull
        public String getQuery() {
            return this.myQuery;
        }

        @NotNull
        public String getType() {
            return this.myType;
        }

        @Internal
        public boolean isShowRecent() {
            return StringUtils.isEmpty((String)this.myQuery);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SQuery sQuery = (SQuery)o;
            if (!this.myQuery.equals(sQuery.myQuery)) {
                return false;
            }
            return this.myType.equals(sQuery.myType);
        }

        public int hashCode() {
            int result = this.myQuery.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }

        public static SQuery fromRest(RestForestSpec rfs) {
            if (rfs == null || rfs.sQuery == null) {
                return null;
            }
            return new SQuery(StructureUtil.nn(rfs.sQuery.type), StructureUtil.nn(rfs.sQuery.query));
        }
    }
}

