/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.Internal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class AttributeSpecNormalization {
    private static final Map<String, Map<String, Integer>> KNOWN_NON_STANDARD_INT_DEFAULTS = AttributeSpecNormalization.immutableMapOf("aggregation-parent", AttributeSpecNormalization.immutableMapOf("depth", -1, "level", -1), "aggregation-join", AttributeSpecNormalization.immutableMapOf("fromdepth", 1, "fromLevel", 1));

    @NotNull
    public static Map<String, Object> normalizeParams(@NotNull String specId, @NotNull Map<String, Object> specParams) {
        if (!AttributeSpecNormalization.isNormalizationNeededForSpec(specId, specParams)) {
            return specParams;
        }
        return AttributeSpecNormalization.normalizeMap(specId, specParams);
    }

    private static boolean isNormalizationNeededForSpec(String specId, Map<String, Object> params) {
        for (Map.Entry<String, Object> e : params.entrySet()) {
            if (!AttributeSpecNormalization.isNormalizationNeededForParameter(specId, e.getKey(), e.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNormalizationNeededForParameter(String specId, String paramId, Object value) {
        if (AttributeSpecNormalization.isValueRemoved(value, specId, paramId)) {
            return true;
        }
        return AttributeSpecNormalization.isNormalizationNeededForValue(value);
    }

    private static boolean isNormalizationNeededForValue(Object value) {
        SpecParam spec = SpecParam.fromValue(value);
        if (spec != null) {
            return AttributeSpecNormalization.isNormalizationNeededForSpec(spec.id, spec.params);
        }
        if (value instanceof List) {
            return AttributeSpecNormalization.isNormalizationNeededForList((List)value);
        }
        return false;
    }

    private static boolean isNormalizationNeededForList(List<Object> value) {
        for (Object element : value) {
            if (!AttributeSpecNormalization.isNormalizationNeededForValue(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<String, Object> normalizeMap(String specId, @NotNull Map<String, Object> specParams) {
        if (specParams.isEmpty()) {
            return specParams;
        }
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>(specParams.size());
        for (Map.Entry<String, Object> e : specParams.entrySet()) {
            String paramId = e.getKey();
            Object value = AttributeSpecNormalization.normalizeValue(e.getValue());
            if (AttributeSpecNormalization.isValueRemoved(value, specId, paramId)) continue;
            r.put(paramId, value);
        }
        return r;
    }

    private static List<Object> normalizeList(@NotNull List<Object> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> r = new ArrayList<Object>(list.size());
        for (Object value : list) {
            r.add(AttributeSpecNormalization.normalizeValue(value));
        }
        return r;
    }

    @Nullable
    private static Object normalizeValue(Object value) {
        SpecParam spec = SpecParam.fromValue(value);
        if (spec != null) {
            Map<String, Object> params;
            LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>(3);
            r.put("id", spec.id);
            if (spec.format != null) {
                r.put("format", spec.format);
            }
            if (!(params = AttributeSpecNormalization.normalizeMap(spec.id, spec.params)).isEmpty()) {
                r.put("params", params);
            }
            return r;
        }
        if (value instanceof List) {
            return AttributeSpecNormalization.normalizeList((List)value);
        }
        return value;
    }

    private static boolean isValueRemoved(Object value, String specId, String paramId) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == AttributeSpecNormalization.getIntDefault(specId, paramId)) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof List && ((List)value).isEmpty()) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }

    private static int getIntDefault(String specId, String paramId) {
        Integer defaultValue;
        Map<String, Integer> map = KNOWN_NON_STANDARD_INT_DEFAULTS.get(specId);
        if (map != null && (defaultValue = map.get(paramId)) != null) {
            return defaultValue;
        }
        return 0;
    }

    private static <K, V> Map<K, V> immutableMapOf(K key, V value) {
        LinkedHashMap<K, V> r = new LinkedHashMap<K, V>();
        r.put(key, value);
        return Collections.unmodifiableMap(r);
    }

    private static <K, V> Map<K, V> immutableMapOf(K key1, V value1, K key2, V value2) {
        LinkedHashMap<K, V> r = new LinkedHashMap<K, V>();
        r.put(key1, value1);
        r.put(key2, value2);
        return Collections.unmodifiableMap(r);
    }

    private static class SpecParam {
        @NotNull
        public final String id;
        @NotNull
        public final Map<String, Object> params;
        @Nullable
        public final String format;

        public SpecParam(@NotNull String id, @NotNull Map<String, Object> params, @Nullable String format) {
            this.id = id;
            this.params = params;
            this.format = format;
        }

        @Nullable
        public static SpecParam fromValue(Object value) {
            if (!(value instanceof Map)) {
                return null;
            }
            Map object = (Map)value;
            Object id = null;
            Object params = null;
            Object format = null;
            for (Map.Entry e : object.entrySet()) {
                String key = (String)e.getKey();
                if ("id".equals(key)) {
                    id = e.getValue();
                    continue;
                }
                if ("params".equals(key)) {
                    params = e.getValue();
                    continue;
                }
                if ("format".equals(key)) {
                    format = e.getValue();
                    continue;
                }
                return null;
            }
            if (!(id instanceof String) || !(params instanceof Map)) {
                return null;
            }
            String stringId = id;
            if (stringId.isEmpty()) {
                return null;
            }
            if (format != null && !(format instanceof String)) {
                return null;
            }
            return new SpecParam(stringId, params, format);
        }
    }
}

