/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.sync.SyncInstance;
import com.almworks.jira.structure.api.util.MapObject;
import com.atlassian.annotations.PublicApi;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface SyncAuditLog {
    public void recordActions(@NotNull SyncInstance var1, @Nullable MapObject var2, @Nullable List<MapObject> var3);

    public void recordActions(long var1, @NotNull String var3, long var4, @Nullable MapObject var6, @Nullable List<MapObject> var7);

    public boolean isActionGroupRecorded(@Nullable List<MapObject> var1);

    public List<ActionGroup> getActions(long var1, long var3, long var5, long var7);

    public static class ActionGroup {
        private final long mySyncInstanceId;
        private final String mySyncModuleKey;
        private final long myStructureId;
        private final long myTimestamp;
        private final MapObject myDescription;
        private final List<MapObject> myActions;

        public ActionGroup(long syncInstanceId, String syncModuleKey, long structureId, long timestamp, MapObject description, List<MapObject> actions) {
            this.mySyncInstanceId = syncInstanceId;
            this.myStructureId = structureId;
            this.mySyncModuleKey = StringUtils.isEmpty((CharSequence)syncModuleKey) ? null : syncModuleKey;
            this.myTimestamp = timestamp;
            this.myDescription = description;
            this.myActions = Collections.unmodifiableList(actions);
        }

        public long getSyncInstanceId() {
            return this.mySyncInstanceId;
        }

        @NotNull
        public String getSyncModuleKey() {
            return this.mySyncModuleKey;
        }

        public long getStructureId() {
            return this.myStructureId;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        @Nullable
        public MapObject getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<MapObject> getActions() {
            return this.myActions;
        }
    }
}

