/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.permissions;

import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.permissions.PermissionSubject;
import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlSeeAlso(value={ApplyStructure.class, SetLevel.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SetLevel.class, name="set"), @JsonSubTypes.Type(value=ApplyStructure.class, name="apply")})
public abstract class PermissionRule
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(PermissionRule.class);

    public abstract String toEncodedString();

    @NotNull
    public abstract PermissionLevel apply(@Nullable ApplicationUser var1, @NotNull PermissionLevel var2, @Nullable List<Object> var3, @Nullable La<Long, List<PermissionRule>> var4);

    @Nullable
    public static PermissionRule fromEncodedString(@Nullable String s) throws ParseException {
        return PermissionRule.fromEncodedString(s, false);
    }

    @Nullable
    public static PermissionRule fromEncodedString(@Nullable String s, boolean usersAsUserNames) throws ParseException {
        try {
            if (s == null || s.length() == 0) {
                return null;
            }
            String p = StringUtils.removeStart((String)s, (String)"apply:");
            if (!p.equals(s)) {
                return new ApplyStructure(Long.parseLong(p));
            }
            p = StringUtils.removeStart((String)s, (String)"set:");
            if (!p.equals(s)) {
                PermissionLevel level;
                int k = p.indexOf(58);
                if (k < 0) {
                    throw new ParseException(s, 0);
                }
                String levelCode = p.substring(0, k);
                try {
                    int levelInt = Integer.parseInt(levelCode);
                    level = PermissionLevel.fromSerial(levelInt);
                }
                catch (NumberFormatException e) {
                    try {
                        level = PermissionLevel.valueOf(levelCode);
                    }
                    catch (IllegalArgumentException ee) {
                        throw e;
                    }
                }
                PermissionSubject subject = PermissionSubject.fromEncodedString(p.substring(k + 1), usersAsUserNames);
                if (subject == null) {
                    throw new ParseException(s, 0);
                }
                return new SetLevel(subject, level);
            }
            throw new ParseException(s, 0);
        }
        catch (NumberFormatException e) {
            throw new ParseException(s, 0);
        }
    }

    @Deprecated
    @NotNull
    public static String encodePermissions(@Nullable List<PermissionRule> permissions) {
        StringBuilder r = new StringBuilder();
        if (permissions != null) {
            for (PermissionRule permission : permissions) {
                if (permission == null) continue;
                if (r.length() > 0) {
                    r.append(',');
                }
                r.append(permission.toEncodedString());
            }
        }
        return r.toString();
    }

    @Deprecated
    @NotNull
    public static List<PermissionRule> decodePermissions(@Nullable String s) throws ParseException {
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        String[] elements = s.split(",");
        ArrayList<PermissionRule> list = new ArrayList<PermissionRule>(elements.length);
        for (String element : elements) {
            PermissionRule rule = PermissionRule.fromEncodedString(element);
            if (rule == null) continue;
            list.add(rule);
        }
        return list;
    }

    public PermissionRule clone() {
        try {
            return (PermissionRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toEncodedString();
    }

    @XmlRootElement(name="apply")
    public static class ApplyStructure
    extends PermissionRule {
        private Long myStructureId;

        public ApplyStructure() {
        }

        public ApplyStructure(Long structureId) {
            this.myStructureId = structureId;
        }

        @XmlAttribute
        @JsonProperty(value="structure")
        public Long getStructureId() {
            return this.myStructureId;
        }

        public void setStructureId(Long structureId) {
            this.myStructureId = structureId;
        }

        @Override
        public String toEncodedString() {
            return "apply:" + this.myStructureId;
        }

        @Override
        @NotNull
        public PermissionLevel apply(ApplicationUser user, @NotNull PermissionLevel pass, List<Object> callStack, La<Long, List<PermissionRule>> resolver) {
            Long id = this.myStructureId;
            if (id == null || resolver == null) {
                return pass;
            }
            if (callStack != null && callStack.contains(id)) {
                logger.error("permissions dependency cycle " + callStack);
                return pass;
            }
            List<PermissionRule> permissions = resolver.la(id);
            if (callStack != null) {
                callStack.add(id);
            }
            PermissionLevel r = StructureUtil.applyPermissions(permissions, user, callStack, resolver, pass);
            if (callStack != null) {
                callStack.remove(id);
            }
            return r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplyStructure that = (ApplyStructure)o;
            return !(this.myStructureId != null ? !this.myStructureId.equals(that.myStructureId) : that.myStructureId != null);
        }

        public int hashCode() {
            return this.myStructureId != null ? this.myStructureId.hashCode() : 0;
        }
    }

    @XmlRootElement(name="set")
    public static class SetLevel
    extends PermissionRule {
        private PermissionSubject mySubject;
        private PermissionLevel myLevel;

        public SetLevel() {
        }

        public SetLevel(PermissionSubject subject, PermissionLevel level) {
            this.mySubject = subject;
            this.myLevel = level;
        }

        @Override
        public SetLevel clone() {
            SetLevel r = (SetLevel)super.clone();
            if (this.mySubject != null) {
                r.mySubject = this.mySubject.clone();
            }
            return r;
        }

        @Override
        @NotNull
        public PermissionLevel apply(ApplicationUser user, @NotNull PermissionLevel pass, List<Object> callStack, La<Long, List<PermissionRule>> resolver) {
            PermissionSubject subject = this.mySubject;
            return subject != null && subject.matches(user) ? this.myLevel : pass;
        }

        @XmlElementRef
        public PermissionSubject getSubject() {
            return this.mySubject;
        }

        public void setSubject(PermissionSubject subject) {
            this.mySubject = subject;
        }

        @XmlAttribute
        public PermissionLevel getLevel() {
            return this.myLevel;
        }

        public void setLevel(PermissionLevel level) {
            this.myLevel = level;
        }

        @Override
        public String toEncodedString() {
            return "set:" + (this.myLevel == null ? "0" : Integer.valueOf(this.myLevel.getSerial())) + ":" + (this.mySubject == null ? "" : this.mySubject.toEncodedString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetLevel setLevel = (SetLevel)o;
            if (this.myLevel != setLevel.myLevel) {
                return false;
            }
            return !(this.mySubject != null ? !this.mySubject.equals(setLevel.mySubject) : setLevel.mySubject != null);
        }

        public int hashCode() {
            int result = this.mySubject != null ? this.mySubject.hashCode() : 0;
            result = 31 * result + (this.myLevel != null ? this.myLevel.hashCode() : 0);
            return result;
        }
    }
}

