/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.permissions;

import com.almworks.jira.structure.api.permissions.StructureAppPermission;
import com.atlassian.annotations.PublicApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface CoreAppPermissions {
    public static final StructureAppPermission USE = new StructureAppPermission("use");
    public static final StructureAppPermission CREATE_STRUCTURE = new StructureAppPermission("createStructure");
    public static final StructureAppPermission SYNCHRONIZATION = new StructureAppPermission("synchronization");
    public static final StructureAppPermission AUTOMATION = new StructureAppPermission("automation");
    public static final StructureAppPermission CONFIGURE_GENERATORS = new StructureAppPermission("configureGenerators");
    public static final StructureAppPermission CONFIGURE_EFFECTORS = new StructureAppPermission("configureEffectors");
    public static final StructureAppPermission EXECUTE_EFFECTORS = new StructureAppPermission("executeEffectors");
    public static final StructureAppPermission EXECUTE_EFFECTORS_ON_QUERIES = new StructureAppPermission("executeEffectorsOnQueries");
    public static final StructureAppPermission MANAGE_GLOBAL_SAVED_COLUMNS = new StructureAppPermission("manageGlobalSavedColumns");
    public static final Set<StructureAppPermission> ALL = Collections.unmodifiableSet(new LinkedHashSet<StructureAppPermission>(Arrays.asList(USE, CREATE_STRUCTURE, SYNCHRONIZATION, AUTOMATION, CONFIGURE_GENERATORS, CONFIGURE_EFFECTORS, EXECUTE_EFFECTORS, EXECUTE_EFFECTORS_ON_QUERIES, MANAGE_GLOBAL_SAVED_COLUMNS)));

    @Nullable
    public static StructureAppPermission byKey(@Nullable String key) {
        return ALL.stream().filter(p -> p.getKey().equals(key)).findAny().orElse(null);
    }
}

