/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item.generic;

import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.StructurePluginHelper;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.item.BulkAccessCheckingItemType;
import com.almworks.jira.structure.api.item.CreatableItemType;
import com.almworks.jira.structure.api.item.DeadItemsCheckingItemType;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemIdentitySet;
import com.almworks.jira.structure.api.item.StructureItemType;
import com.almworks.jira.structure.api.item.StructureOwnedItemType;
import com.almworks.jira.structure.api.item.UpdatableItemType;
import com.almworks.jira.structure.api.item.generic.GenericItem;
import com.almworks.jira.structure.api.item.generic.GenericItemManager;
import com.almworks.jira.structure.api.item.generic.GenericItemService;
import com.almworks.jira.structure.api.row.DummyRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.ModuleDescriptor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class GenericItemType
implements StructureItemType<GenericItem>,
CreatableItemType,
UpdatableItemType,
StructureOwnedItemType,
DeadItemsCheckingItemType,
BulkAccessCheckingItemType {
    private static final Logger logger = LoggerFactory.getLogger(GenericItemType.class);
    public static final long NEW_ITEM_ID = Long.MAX_VALUE;
    protected final GenericItemService myGenericItemService;
    protected final GenericItemManager myGenericItemManager;
    protected final StructurePluginHelper myHelper;
    private volatile String myItemType;
    private final ObjectMapper myObjectMapper = new ObjectMapper();
    private final TypeReference<Map<String, Object>> myJsonMapTypeRef = new TypeReference<Map<String, Object>>(){};

    public GenericItemType(GenericItemService genericItemService, GenericItemManager genericItemManager, StructurePluginHelper helper) {
        this.myGenericItemService = genericItemService;
        this.myGenericItemManager = genericItemManager;
        this.myHelper = helper;
    }

    @Internal
    public void init(ModuleDescriptor descriptor) {
        if (this.myItemType == null) {
            this.myItemType = descriptor.getCompleteKey();
        }
    }

    @Override
    @Nullable
    public GenericItem accessItem(@NotNull ItemIdentity itemId) {
        if (this.myItemType.equals(itemId.getItemType()) && itemId.isLongId() && itemId.getLongId() != Long.MAX_VALUE) {
            return this.myGenericItemManager.getItem(itemId);
        }
        return null;
    }

    @Override
    public boolean isVisible(@NotNull GenericItem item, @Nullable ApplicationUser user) {
        return this.myGenericItemManager.isVisible(item, user);
    }

    @Override
    public StructureRow createDummyRow(long rowId, long semantics, Map<String, Object> values, ErrorCollection errors) throws StructureException {
        GenericItem genericItem = this.buildGenericItem(values, errors);
        if (genericItem == null) {
            return null;
        }
        GenericItemService.CreateValidationResult validationResult = this.myGenericItemService.validateCreate(this.myItemType, genericItem);
        if (validationResult.isValid()) {
            return new DummyRow(rowId, ItemIdentity.longId(this.myItemType, Long.MAX_VALUE), semantics, genericItem);
        }
        this.handleInvalidResult(validationResult, errors);
        return null;
    }

    @Override
    public ItemIdentity createItem(Map<String, Object> values, ErrorCollection errors) throws StructureException {
        GenericItem genericItem = this.buildGenericItem(values, errors);
        if (genericItem == null) {
            return null;
        }
        GenericItemService.CreateValidationResult validationResult = this.myGenericItemService.validateCreate(this.myItemType, genericItem);
        GenericItemService.GenericItemResult createResult = this.myGenericItemService.create(validationResult);
        if (createResult.isValid()) {
            return createResult.getItemId();
        }
        this.handleInvalidResult(createResult, errors);
        return null;
    }

    @Nullable
    private GenericItem buildGenericItem(Map<String, Object> values, ErrorCollection errors) {
        String name = this.getName(values, errors);
        if (name == null) {
            return null;
        }
        GenericItem.Builder builder = GenericItem.named(name);
        this.readItemValues(builder, values, null, errors);
        if (errors.hasAnyErrors()) {
            return null;
        }
        return builder.build();
    }

    @Override
    public void updateItem(ItemIdentity itemId, Map<String, Object> values, ErrorCollection errors) throws StructureException {
        if (!this.myItemType.equals(itemId.getItemType())) {
            throw StructureErrors.INVALID_PARAMETER.withMessage(itemId + " is not a " + this.myItemType + " ID");
        }
        GenericItem existing = this.accessItem(itemId);
        if (existing == null || !this.isVisible(existing, StructureAuth.getUser())) {
            throw StructureErrors.ITEM_NOT_EXISTS_OR_NOT_ACCESSIBLE.forItem(itemId).withMessage(itemId + " is not found or not accessible");
        }
        GenericItem.Builder builder = GenericItem.copy(existing);
        if (values.containsKey("summary")) {
            String name = this.getName(values, errors);
            if (name == null) {
                return;
            }
            builder.setName(name);
        }
        this.readItemValues(builder, values, existing, errors);
        if (errors.hasAnyErrors()) {
            return;
        }
        GenericItem genericItem = builder.build();
        GenericItemService.UpdateValidationResult validationResult = this.myGenericItemService.validateUpdate(itemId, genericItem);
        GenericItemService.GenericItemResult updateResult = this.myGenericItemService.update(validationResult);
        if (!updateResult.isValid()) {
            this.handleInvalidResult(updateResult, errors);
        }
    }

    @Override
    @NotNull
    public ItemIdentity getOwnedItem(@NotNull ItemIdentity itemId, long structureId, boolean copyIfSame) throws StructureException {
        if (this.myItemType.equals(itemId.getItemType()) && itemId.isLongId()) {
            return this.myGenericItemManager.getOwnedItem(itemId, structureId, copyIfSame);
        }
        return itemId;
    }

    @Override
    public void filterDead(ItemIdentitySet items, ItemIdentitySet deadCollector) {
        for (LongIterator it : items.longIds(this.myItemType)) {
            ItemIdentity itemId = ItemIdentity.longId(this.myItemType, it.value());
            GenericItem genericItem = this.accessItem(itemId);
            if (genericItem != null) continue;
            deadCollector.add(itemId);
        }
    }

    @Override
    public void filterInaccessible(ItemIdentitySet items, ApplicationUser user, boolean overrideSecurity, ItemIdentitySet inaccessibleCollector) {
        ItemIdentitySet itemsToLoad = items.stream().filter(itemId -> itemId.getLongId() != Long.MAX_VALUE).collect(Collectors.toCollection(ItemIdentitySet::new));
        if (itemsToLoad.isEmpty()) {
            return;
        }
        ItemIdentitySet notFound = itemsToLoad.copy();
        this.myGenericItemManager.loadItems(itemsToLoad, (itemId, item) -> {
            notFound.remove(itemId);
            if (!overrideSecurity && !this.isVisible((GenericItem)item, user)) {
                inaccessibleCollector.add((ItemIdentity)itemId);
            }
        });
        inaccessibleCollector.addAll(notFound);
    }

    @Nullable
    private String getName(Map<String, Object> values, ErrorCollection errors) {
        String name = StructureUtil.getSingleParameter(values, "summary");
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.addError("summary", this.myHelper.getI18n().getText("s.ext.it.item.error.name-blank"));
            return null;
        }
        return name;
    }

    protected void readItemValues(@NotNull GenericItem.Builder builder, @Nullable Map<String, Object> values, @Nullable GenericItem existing, @NotNull ErrorCollection errors) {
        if (values == null) {
            return;
        }
        if (values.containsKey("description")) {
            builder.setDescription(StructureUtil.getSingleParameter(values, "description"));
        }
        if (values.containsKey("params")) {
            Map<String, Object> params = this.convertToMap(values.get("params"));
            if (params == null) {
                builder.setParameters(null);
            } else {
                params.forEach(builder::setParameter);
            }
        }
    }

    private Map<String, Object> convertToMap(Object object) {
        try {
            return (Map)this.myObjectMapper.convertValue(object, this.myJsonMapTypeRef);
        }
        catch (IllegalArgumentException e) {
            logger.warn("failed to convert {} to {}", new Object[]{object, this.myJsonMapTypeRef, e});
            return null;
        }
    }

    private void handleInvalidResult(GenericItemService.ExceptionSupportResult result, ErrorCollection errors) throws StructureException {
        if (result.getException() != null) {
            throw result.getException();
        }
        errors.addErrorCollection(result.getErrorCollection());
    }
}

