/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.effect;

import com.almworks.jira.structure.api.effect.Effect;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.I18nText;
import com.atlassian.annotations.PublicApi;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class EffectResponse {
    @NotNull
    private final I18nText myDescription;
    @NotNull
    private final List<ItemIdentity> myAffectedItems;

    private EffectResponse(@NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
        this.myDescription = description;
        this.myAffectedItems = affectedItems;
    }

    @Nullable
    public Effect getEffect() {
        return null;
    }

    @NotNull
    public List<ItemIdentity> getAffectedItems() {
        return this.myAffectedItems;
    }

    @NotNull
    public I18nText getDescription() {
        return this.myDescription;
    }

    @Nullable
    public I18nText getSuccessMessage() {
        return null;
    }

    @Nullable
    public I18nText getError() {
        return null;
    }

    public boolean isError() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public static EffectResponse valid(@NotNull Effect effect, @NotNull I18nText successMessage, @NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
        return new Valid(effect, successMessage, description, affectedItems);
    }

    @NotNull
    public static EffectResponse error(@NotNull I18nText error, @NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
        return new Error(error, description, affectedItems);
    }

    @NotNull
    public static EffectResponse empty(@NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
        return new Empty(description, affectedItems);
    }

    public static final class Valid
    extends EffectResponse {
        @NotNull
        private final Effect myEffect;
        @NotNull
        private final I18nText mySuccessMessage;

        private Valid(@NotNull Effect effect, @NotNull I18nText successMessage, @NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
            super(description, affectedItems);
            this.myEffect = effect;
            this.mySuccessMessage = successMessage;
        }

        @Override
        @NotNull
        public Effect getEffect() {
            return this.myEffect;
        }

        @Override
        @NotNull
        public I18nText getSuccessMessage() {
            return this.mySuccessMessage;
        }
    }

    public static final class Error
    extends EffectResponse {
        @NotNull
        private final I18nText myError;

        public Error(@NotNull I18nText error, @NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
            super(description, affectedItems);
            this.myError = error;
        }

        @Override
        @NotNull
        public I18nText getError() {
            return this.myError;
        }

        @Override
        public boolean isError() {
            return true;
        }
    }

    public static final class Empty
    extends EffectResponse {
        public Empty(@NotNull I18nText description, @NotNull List<ItemIdentity> affectedItems) {
            super(description, affectedItems);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

