/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.darkfeature;

import com.almworks.jira.structure.api.util.ConsiderateLogger;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.properties.ApplicationProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@PublicApi
public class DarkFeatures {
    private static final ConsiderateLogger logger = new ConsiderateLogger(LoggerFactory.getLogger(DarkFeatures.class));

    public static long getLong(@NotNull String propertyName, long defaultValue) {
        String value = DarkFeatures.getApplicationProperty(propertyName);
        return StringUtils.isNotEmpty((CharSequence)value) ? StructureUtil.lv(value, defaultValue) : Long.getLong(propertyName, defaultValue);
    }

    public static int getInteger(@NotNull String propertyName, int defaultValue) {
        String value = DarkFeatures.getApplicationProperty(propertyName);
        return StringUtils.isNotEmpty((CharSequence)value) ? StructureUtil.iv(value, defaultValue) : Integer.getInteger(propertyName, defaultValue);
    }

    public static boolean getBoolean(@NotNull String propertyName) {
        return DarkFeatures.getBoolean(propertyName, false);
    }

    public static boolean getBoolean(@NotNull String propertyName, boolean defaultValue) {
        String value = DarkFeatures.getApplicationProperty(propertyName);
        return StringUtils.isNotEmpty((CharSequence)value) ? Boolean.parseBoolean(value) : StructureUtil.getBooleanSystemProperty(propertyName, defaultValue);
    }

    @Nullable
    public static String getProperty(@NotNull String propertyName) {
        return DarkFeatures.getProperty(propertyName, null);
    }

    @Contract(value="_, !null -> !null")
    public static String getProperty(@NotNull String propertyName, @Nullable String defaultValue) {
        String value = DarkFeatures.getApplicationProperty(propertyName);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : System.getProperty(propertyName, defaultValue);
    }

    @Nullable
    @Internal
    public static String getApplicationProperty(@NotNull String propertyName) {
        try {
            ApplicationProperties applicationProperties = JiraComponents.getApplicationProperties();
            return applicationProperties == null ? null : applicationProperties.getString(propertyName);
        }
        catch (Exception | LinkageError e) {
            logger.warn("DarkFeatures:", "failed to get feature value from application properties", e);
            return null;
        }
    }
}

