/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.error.StructureRuntimeException;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Immutable
public abstract class AttributeValue<T> {
    private AttributeValue() {
    }

    @NotNull
    public static <T> AttributeValue<T> of(@NotNull T value) {
        assert (value != null);
        return AttributeValue.ofNullable(value);
    }

    @NotNull
    public static <T> AttributeValue<T> ofNullable(@Nullable T value) {
        return value == null ? AttributeValue.undefined() : new Defined(value);
    }

    @NotNull
    public static <T> AttributeValue<T> undefined() {
        return Undefined.BARE_UNDEFINED;
    }

    @NotNull
    public static <T> AttributeValue<T> error() {
        return Undefined.BARE_ERROR;
    }

    @Internal
    @NotNull
    public static <T> AttributeValue<T> absent() {
        return Undefined.BARE_ABSENT;
    }

    @Internal
    @NotNull
    public static <T> AttributeValue<T> inaccessible() {
        return Undefined.BARE_INACCESSIBLE;
    }

    @NotNull
    public abstract AttributeValue<T> withData(@Nullable Object var1);

    @Nullable
    public abstract T getValue();

    @NotNull
    public final T getDefinedValue() {
        T value = this.getValue();
        if (value == null) {
            throw new StructureRuntimeException("unexpected undefined value");
        }
        return value;
    }

    @NotNull
    public abstract AttributeValue<T> ifPresent(@NotNull Consumer<? super T> var1);

    public abstract boolean isDefined();

    public abstract boolean isError();

    public abstract boolean isAbsent();

    public abstract boolean isInaccessible();

    @Nullable
    public <D> D getLoaderData(Class<D> valueClass) {
        return null;
    }

    @NotNull
    @Internal
    public <X> AttributeValue<X> cast(AttributeSpec<X> spec) {
        T value = this.getValue();
        if (value != null && !spec.getFormat().getValueClass().isInstance(value)) {
            assert (false) : this + " " + spec;
            return null;
        }
        return this;
    }

    @Immutable
    private static class Defined<T>
    extends AttributeValue<T> {
        @NotNull
        private final T myValue;

        private Defined(@NotNull T value) {
            this.myValue = value;
        }

        @Override
        @NotNull
        public AttributeValue<T> withData(@Nullable Object loaderData) {
            return loaderData == null ? this : new DefinedWithLoaderData<T>(this.myValue, loaderData);
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public boolean isAbsent() {
            return false;
        }

        @Override
        public boolean isInaccessible() {
            return false;
        }

        @Override
        @NotNull
        public T getValue() {
            return this.myValue;
        }

        @Override
        @NotNull
        public AttributeValue<T> ifPresent(@NotNull Consumer<? super T> consumer) {
            consumer.accept(this.myValue);
            return this;
        }

        public String toString() {
            return String.valueOf(this.myValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Defined that = (Defined)o;
            return this.myValue.equals(that.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    @Immutable
    private static class Undefined<T>
    extends AttributeValue<T> {
        private static final AttributeValue BARE_UNDEFINED = new Undefined(UndefinedKind.UNDEFINED);
        private static final AttributeValue BARE_ERROR = new Undefined(UndefinedKind.ERROR);
        private static final AttributeValue BARE_ABSENT = new Undefined(UndefinedKind.ABSENT);
        private static final AttributeValue BARE_INACCESSIBLE = new Undefined(UndefinedKind.INACCESSIBLE);
        @NotNull
        private final UndefinedKind myKind;

        public Undefined(@NotNull UndefinedKind kind) {
            this.myKind = kind;
        }

        @Override
        @NotNull
        public AttributeValue<T> withData(@Nullable Object loaderData) {
            return loaderData == null ? this : new UndefinedWithLoaderData(this.myKind, loaderData);
        }

        @Override
        @Nullable
        public T getValue() {
            return null;
        }

        @Override
        @NotNull
        public AttributeValue<T> ifPresent(@NotNull Consumer<? super T> consumer) {
            return this;
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public boolean isError() {
            return this.myKind == UndefinedKind.ERROR;
        }

        @Override
        public boolean isAbsent() {
            return this.myKind == UndefinedKind.ABSENT;
        }

        @Override
        public boolean isInaccessible() {
            return this.myKind == UndefinedKind.INACCESSIBLE;
        }

        @NotNull
        public UndefinedKind getKind() {
            return this.myKind;
        }

        public String toString() {
            switch (this.myKind) {
                case ERROR: {
                    return "<!>";
                }
                case ABSENT: {
                    return "<->";
                }
                case INACCESSIBLE: {
                    return "<#>";
                }
            }
            return "<?>";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Undefined that = (Undefined)o;
            return this.myKind == that.myKind;
        }

        public int hashCode() {
            return this.myKind.hashCode();
        }
    }

    private static enum UndefinedKind {
        UNDEFINED,
        ERROR,
        ABSENT,
        INACCESSIBLE;

    }

    @Immutable
    private static class UndefinedWithLoaderData<T>
    extends Undefined<T> {
        @NotNull
        private final Object myLoaderData;

        public UndefinedWithLoaderData(@NotNull UndefinedKind kind, @NotNull Object loaderData) {
            super(kind);
            this.myLoaderData = loaderData;
        }

        @Override
        @Nullable
        public <D> D getLoaderData(Class<D> valueClass) {
            return valueClass.isInstance(this.myLoaderData) ? (D)valueClass.cast(this.myLoaderData) : null;
        }

        @Override
        @NotNull
        public AttributeValue<T> withData(@Nullable Object loaderData) {
            UndefinedKind kind = this.getKind();
            return loaderData == null ? new Undefined(kind) : new UndefinedWithLoaderData<T>(kind, loaderData);
        }

        @Override
        public String toString() {
            return super.toString() + " (+)";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UndefinedWithLoaderData that = (UndefinedWithLoaderData)o;
            return this.myLoaderData.equals(that.myLoaderData);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myLoaderData.hashCode();
        }
    }

    @Immutable
    private static class DefinedWithLoaderData<T>
    extends Defined<T> {
        @NotNull
        private final Object myLoaderData;

        public DefinedWithLoaderData(@NotNull T value, @NotNull Object loaderData) {
            super(value);
            this.myLoaderData = loaderData;
        }

        @Override
        @Nullable
        public <D> D getLoaderData(Class<D> valueClass) {
            return valueClass.isInstance(this.myLoaderData) ? (D)valueClass.cast(this.myLoaderData) : null;
        }

        @Override
        @NotNull
        public AttributeValue<T> withData(@Nullable Object loaderData) {
            Object value = this.getValue();
            return loaderData == null ? new Defined(value) : new DefinedWithLoaderData(value, loaderData);
        }

        @Override
        public String toString() {
            return super.toString() + " (+)";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DefinedWithLoaderData that = (DefinedWithLoaderData)o;
            return this.myLoaderData.equals(that.myLoaderData);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myLoaderData.hashCode();
        }
    }
}

