/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.pull.DataVersion;
import com.almworks.jira.structure.api.pull.VersionedDataUpdate;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ItemVersionUpdate
extends VersionedDataUpdate {
    protected ItemVersionUpdate(@NotNull DataVersion version) {
        super(version);
    }

    @NotNull
    public abstract DataVersion getFromVersion();

    @NotNull
    public abstract Set<ItemIdentity> getAffectedItems();

    public static final class Total
    extends ItemVersionUpdate {
        public Total(@NotNull DataVersion version) {
            super(version);
        }

        @Override
        @NotNull
        public DataVersion getFromVersion() {
            return DataVersion.ZERO;
        }

        @Override
        public boolean isFull() {
            return true;
        }

        @Override
        @NotNull
        public Set<ItemIdentity> getAffectedItems() {
            return Collections.emptySet();
        }

        public String toString() {
            return String.format("FULL[%s]", this.getVersion());
        }
    }

    public static final class Empty
    extends ItemVersionUpdate {
        public Empty(@NotNull DataVersion version) {
            super(version);
        }

        @Override
        @NotNull
        public DataVersion getFromVersion() {
            return this.getVersion();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Set<ItemIdentity> getAffectedItems() {
            return Collections.emptySet();
        }

        public String toString() {
            return String.format("empty[%s]", this.getVersion());
        }
    }
}

