/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.sync.SyncAuditLogHelper;
import com.almworks.jira.structure.api.sync.SyncEvent;
import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SyncEvents {
    public static final La<SyncEvent.Jira, Map<String, Object>> JIRA_EVENT_TO_MAP = new La<SyncEvent.Jira, Map<String, Object>>(){

        @Override
        public Map<String, Object> la(SyncEvent.Jira event) {
            if (event == null) {
                return null;
            }
            return SyncEvents.buildSyncEventMap(event, (ImmutableMap.Builder<String, Object>)ImmutableMap.builder().put((Object)"type", (Object)event.getEvent().getChangeType().toString()).put((Object)"issues", SyncAuditLogHelper.ISSUE_INFO.arrayList(event.getEvent().getAffectedIssuesSorted().toList())));
        }
    };
    public static final La<SyncEvent.Structure, Map<String, Object>> STRUCTURE_EVENT_TO_MAP = new La<SyncEvent.Structure, Map<String, Object>>(){

        @Override
        public Map<String, Object> la(SyncEvent.Structure event) {
            if (event == null) {
                return null;
            }
            return SyncEvents.buildSyncEventMap(event, (ImmutableMap.Builder<String, Object>)ImmutableMap.builder().put((Object)"version", (Object)event.getHistoryEntry().getVersion()));
        }
    };

    @NotNull
    private static Map<String, Object> buildSyncEventMap(@NotNull SyncEvent event, ImmutableMap.Builder<String, Object> builder) {
        builder.put((Object)"timestamp", (Object)event.getTimestamp());
        builder.put((Object)"syncInstanceId", (Object)StructureUtil.nnl(event.getSyncInstanceId()));
        return builder.build();
    }
}

