/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.almworks.jira.structure.api.row.ItemAccessMode;
import com.almworks.jira.structure.api.row.ShallowRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.row.StructureRows;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class SimpleRow
implements StructureRow {
    protected final long myRowId;
    @NotNull
    protected final ItemIdentity myItemId;
    protected final long mySemantics;
    @NotNull
    protected final ItemResolver myResolver;
    @Nullable
    private Object myItem;
    private volatile boolean myItemLoaded;

    @NotNull
    public static StructureRow create(long rowId, @NotNull ItemIdentity itemId, long semantics, @Nullable ItemResolver resolver) {
        return SimpleRow.create(rowId, itemId, semantics, resolver, false);
    }

    public static StructureRow create(long rowId, ItemIdentity itemId, long semantics, @Nullable ItemResolver resolver, ItemAccessMode accessMode) {
        if (accessMode == ItemAccessMode.ITEM_NOT_NEEDED) {
            return new ShallowRow(rowId, itemId, semantics);
        }
        return SimpleRow.create(rowId, itemId, semantics, resolver, accessMode == ItemAccessMode.SKIP_ACCESS_CHECK);
    }

    public static StructureRow create(long rowId, ItemIdentity itemId, long semantics, @Nullable ItemResolver resolver, boolean skipAccessCheck) {
        if (resolver == null) {
            return new ShallowRow(rowId, itemId, semantics);
        }
        if (skipAccessCheck) {
            return new Unchecked(rowId, itemId, semantics, resolver);
        }
        return new SimpleRow(rowId, itemId, semantics, resolver);
    }

    private SimpleRow(long rowId, @NotNull ItemIdentity itemId, long semantics, @NotNull ItemResolver resolver) {
        StructureRows.validateForestRowId(rowId);
        this.myRowId = rowId;
        this.myItemId = itemId;
        this.mySemantics = semantics;
        this.myResolver = resolver;
    }

    @Override
    public long getRowId() {
        return this.myRowId;
    }

    @Override
    @NotNull
    public ItemIdentity getItemId() {
        return this.myItemId;
    }

    @Override
    public long getSemantics() {
        return this.mySemantics;
    }

    protected String getQualifier() {
        return "SimpleRow";
    }

    public String toString() {
        return this.getQualifier() + "[" + this.myRowId + ":" + this.myItemId + ":" + this.mySemantics + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <I> I getItem(@NotNull Class<I> itemClass) {
        if (!this.myItemLoaded) {
            SimpleRow simpleRow = this;
            synchronized (simpleRow) {
                if (!this.myItemLoaded) {
                    try {
                        this.myItem = this.resolve();
                    }
                    finally {
                        this.myItemLoaded = true;
                    }
                }
            }
        }
        return itemClass.isInstance(this.myItem) ? (I)itemClass.cast(this.myItem) : null;
    }

    protected Object resolve() {
        return this.myResolver.resolveItem(this.myItemId, Object.class);
    }

    public static StructureRow tryMakeUnchecked(StructureRow r) {
        if (r instanceof Unchecked || !(r instanceof SimpleRow)) {
            return r;
        }
        ItemResolver resolver = ((SimpleRow)r).myResolver;
        return new Unchecked(r.getRowId(), r.getItemId(), r.getSemantics(), resolver);
    }

    static final class Unchecked
    extends SimpleRow {
        private Unchecked(long rowId, @NotNull ItemIdentity itemId, long semantics, @NotNull ItemResolver resolver) {
            super(rowId, itemId, semantics, resolver);
        }

        @Override
        protected Object resolve() {
            return this.myResolver.resolveUnchecked(this.myItemId);
        }

        @Override
        protected String getQualifier() {
            return "SimpleRow(unchecked)";
        }
    }
}

