/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.error;

import com.almworks.jira.structure.api.error.StructureErrorCategory;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@PublicSpi
public interface StructureError {
    public int getCode();

    public StructureErrorCategory getCategory();

    @NotNull
    default public String name() {
        return "error#" + this.getCode();
    }

    default public boolean is(StructureErrorCategory category) {
        return this.getCategory() == category;
    }

    default public boolean isOneOf(StructureErrorCategory ... categories) {
        StructureErrorCategory c = this.getCategory();
        for (StructureErrorCategory category : categories) {
            if (c != category) continue;
            return true;
        }
        return false;
    }

    default public boolean isOneOf(StructureError ... errors) {
        for (StructureError error : errors) {
            if (!this.equals(error)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public StructureException.Builder builder() {
        return new StructureException.Builder(this);
    }

    @NotNull
    default public StructureException withLocalizedMessage(@NotNull String messageKey, Object ... messageParameters) {
        return this.builder().withLocalizedMessage(messageKey, messageParameters);
    }

    @NotNull
    default public StructureException withMessage(@Nullable String message) {
        return this.builder().withMessage(message);
    }

    @NotNull
    default public StructureException withoutMessage() {
        return this.builder().withoutMessage();
    }

    @NotNull
    default public StructureException.Builder forStructure(@Nullable Long structure) {
        return this.builder().forStructure(structure);
    }

    @NotNull
    default public StructureException.Builder forView(@Nullable Long view) {
        return this.builder().forView(view);
    }

    @NotNull
    default public StructureException.Builder forRow(@Nullable Long row) {
        return this.builder().forRow(row);
    }

    @NotNull
    default public StructureException.Builder forItem(@Nullable ItemIdentity item) {
        return this.builder().forItem(item);
    }

    @NotNull
    default public StructureException.Builder forIssue(long issueId) {
        return this.forItem(CoreIdentities.issue(issueId));
    }

    @NotNull
    default public StructureException.Builder causedBy(@Nullable Throwable cause) {
        return this.builder().causedBy(cause);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CodeRange {
        public int from();

        public int to();
    }
}

