/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.atlassian.annotations.PublicApi;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public enum AttributeContextDependency {
    USER,
    USER_LOCALE,
    USER_TIMEZONE,
    STRUCTURE,
    CURRENT_TIME,
    TRAIL;


    public static Set<AttributeContextDependency> guessContextDependencies(AttributeSpec<?> spec) {
        if (ValueFormat.HTML.equals(spec.getFormat())) {
            return EnumSet.of(USER);
        }
        return null;
    }

    @NotNull
    public static Set<AttributeContextDependency> union(@Nullable Set<AttributeContextDependency> set, AttributeContextDependency ... additional) {
        EnumSet<AttributeContextDependency> result = EnumSet.noneOf(AttributeContextDependency.class);
        if (set != null) {
            result.addAll(set);
        }
        if (additional != null) {
            for (AttributeContextDependency dependency : additional) {
                if (dependency == null) continue;
                result.add(dependency);
            }
        }
        return result;
    }
}

