/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.permissions;

import com.almworks.jira.structure.api.settings.StructureConfiguration;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.JiraUsers;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.jetbrains.annotations.Nullable;

@XmlRootElement
@XmlSeeAlso(value={Anyone.class, JiraUser.class, JiraGroup.class, ProjectRole.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Anyone.class, name="anyone"), @JsonSubTypes.Type(value=JiraUser.class, name="user"), @JsonSubTypes.Type(value=JiraGroup.class, name="group"), @JsonSubTypes.Type(value=ProjectRole.class, name="project.role")})
public abstract class PermissionSubject
implements Cloneable {
    public abstract boolean matches(@Nullable ApplicationUser var1);

    public abstract String toEncodedString();

    @Nullable
    public static PermissionSubject fromEncodedString(@Nullable String s) throws ParseException {
        return PermissionSubject.fromEncodedString(s, false);
    }

    @Nullable
    public static PermissionSubject fromEncodedString(@Nullable String s, boolean usersAsUserNames) throws ParseException {
        if (s == null || s.length() == 0) {
            return null;
        }
        String p = StringUtils.removeStart((String)s, (String)"anyone");
        if (!p.equals(s)) {
            return new Anyone();
        }
        p = StringUtils.removeStart((String)s, (String)"user:");
        if (!p.equals(s)) {
            if (usersAsUserNames) {
                p = StructureUtil.migrateUserNameToUserKey(p);
            }
            return new JiraUser(p);
        }
        p = StringUtils.removeStart((String)s, (String)"group:");
        if (!p.equals(s)) {
            return new JiraGroup(p);
        }
        p = StringUtils.removeStart((String)s, (String)"role:");
        if (!p.equals(s)) {
            int k = p.indexOf(58);
            if (k < 0) {
                return null;
            }
            try {
                long project = Long.parseLong(p.substring(0, k));
                long role = Long.parseLong(p.substring(k + 1));
                return new ProjectRole(project, role);
            }
            catch (NumberFormatException e) {
                throw new ParseException(s, 0);
            }
        }
        throw new ParseException(s, 0);
    }

    public PermissionSubject clone() {
        try {
            return (PermissionSubject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toEncodedString();
    }

    @Nullable
    public abstract <T> T visit(Visitor<T> var1, @Nullable T var2);

    @Nullable
    public static PermissionSubject clone(@Nullable PermissionSubject owner) {
        return owner == null ? null : owner.clone();
    }

    public static interface Visitor<T> {
        public T onAnyone(Anyone var1, T var2);

        public T onUser(JiraUser var1, T var2);

        public T onGroup(JiraGroup var1, T var2);

        public T onProjectRole(ProjectRole var1, T var2);

        public static abstract class NoCarry
        implements Visitor<Void> {
            public abstract void onAnyone(Anyone var1);

            public abstract void onUser(JiraUser var1);

            public abstract void onGroup(JiraGroup var1);

            public abstract void onProjectRole(ProjectRole var1);

            @Override
            public Void onAnyone(Anyone anyone, Void carry) {
                this.onAnyone(anyone);
                return carry;
            }

            @Override
            public Void onUser(JiraUser user, Void carry) {
                this.onUser(user);
                return carry;
            }

            @Override
            public Void onGroup(JiraGroup group, Void carry) {
                this.onGroup(group);
                return carry;
            }

            @Override
            public Void onProjectRole(ProjectRole projectRole, Void carry) {
                this.onProjectRole(projectRole);
                return carry;
            }
        }
    }

    @XmlRootElement(name="role")
    @XmlType(name="role")
    public static class ProjectRole
    extends PermissionSubject {
        private long myProjectId;
        private long myRoleId;

        public ProjectRole() {
        }

        public ProjectRole(long projectId, long roleId) {
            this.myProjectId = projectId;
            this.myRoleId = roleId;
        }

        @XmlAttribute
        @JsonProperty(value="project")
        public long getProjectId() {
            return this.myProjectId;
        }

        public void setProjectId(long projectId) {
            this.myProjectId = projectId;
        }

        @XmlAttribute
        @JsonProperty(value="role")
        public long getRoleId() {
            return this.myRoleId;
        }

        public void setRoleId(long roleId) {
            this.myRoleId = roleId;
        }

        @Override
        public boolean matches(ApplicationUser user) {
            List<Object> projects;
            if (this.myRoleId == 0L) {
                return false;
            }
            ProjectRoleManager rm = JiraComponents.getComponentOfType(ProjectRoleManager.class);
            com.atlassian.jira.security.roles.ProjectRole role = rm.getProjectRole(Long.valueOf(this.myRoleId));
            if (role == null) {
                return false;
            }
            if (this.myProjectId == 0L) {
                StructureConfiguration configuration = JiraComponents.getOSGiComponentInstanceOfType(StructureConfiguration.class);
                if (configuration == null) {
                    return false;
                }
                projects = configuration.getCurrentlyEnabledProjects();
            } else {
                ProjectManager pm = JiraComponents.getProjectManager();
                Project project = pm.getProjectObj(Long.valueOf(this.myProjectId));
                projects = project == null ? Collections.emptyList() : Collections.singletonList(project);
            }
            for (Project project : projects) {
                if (!rm.isUserInProjectRole(user, role, project)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toEncodedString() {
            return "role:" + this.myProjectId + ":" + this.myRoleId;
        }

        @Override
        public <T> T visit(Visitor<T> visitor, T carry) {
            return visitor.onProjectRole(this, carry);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectRole that = (ProjectRole)o;
            if (this.myProjectId != that.myProjectId) {
                return false;
            }
            return this.myRoleId == that.myRoleId;
        }

        public int hashCode() {
            int result = (int)(this.myProjectId ^ this.myProjectId >>> 32);
            result = 31 * result + (int)(this.myRoleId ^ this.myRoleId >>> 32);
            return result;
        }
    }

    @XmlRootElement(name="group")
    @XmlType(name="group")
    public static class JiraGroup
    extends PermissionSubject {
        @Nullable
        private String myGroupName;

        public JiraGroup() {
        }

        public JiraGroup(@Nullable String groupName) {
            this.myGroupName = groupName;
        }

        public JiraGroup(@Nullable Group group) {
            this.myGroupName = group == null ? null : group.getName();
        }

        @XmlAttribute(name="name")
        @JsonProperty(value="name")
        @Nullable
        public String getGroupName() {
            return this.myGroupName;
        }

        public void setGroupName(@Nullable String groupName) {
            this.myGroupName = groupName;
        }

        @Override
        public boolean matches(ApplicationUser user) {
            if (this.myGroupName == null || user == null) {
                return false;
            }
            return JiraComponents.getGroupManager().isUserInGroup(user, this.myGroupName);
        }

        @Override
        public String toEncodedString() {
            return "group:" + this.myGroupName;
        }

        @Override
        public <T> T visit(Visitor<T> visitor, T carry) {
            return visitor.onGroup(this, carry);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JiraGroup jiraGroup = (JiraGroup)o;
            return !(this.myGroupName != null ? !this.myGroupName.equals(jiraGroup.myGroupName) : jiraGroup.myGroupName != null);
        }

        public int hashCode() {
            return this.myGroupName != null ? this.myGroupName.hashCode() : 0;
        }
    }

    @XmlRootElement(name="user")
    @XmlType(name="user")
    public static class JiraUser
    extends PermissionSubject {
        @Nullable
        private String myUserKey;

        public JiraUser() {
        }

        public JiraUser(@Nullable String userKey) {
            this.myUserKey = userKey;
        }

        public JiraUser(@Nullable ApplicationUser user) {
            this.myUserKey = JiraUsers.getKeyFor(user);
        }

        @XmlTransient
        @JsonIgnore
        @Nullable
        public String getUserName() {
            return StructureUtil.getUserNameByKey(this.myUserKey);
        }

        @XmlAttribute(name="name")
        @JsonProperty(value="name")
        @Nullable
        public String getUserKey() {
            return this.myUserKey;
        }

        public void setUserName(@Nullable String userName) {
            ApplicationUser user = StructureUtil.getApplicationUserByName(userName);
            this.myUserKey = StructureUtil.getUserKey(user);
        }

        public void setUserKey(@Nullable String userKey) {
            this.myUserKey = userKey;
        }

        @Override
        public boolean matches(ApplicationUser user) {
            return this.myUserKey == null ? user == null : this.myUserKey.equals(JiraUsers.getKeyFor(user));
        }

        @Override
        public String toEncodedString() {
            return "user:" + this.myUserKey;
        }

        @Override
        public <T> T visit(Visitor<T> visitor, T carry) {
            return visitor.onUser(this, carry);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JiraUser jiraUser = (JiraUser)o;
            return !(this.myUserKey != null ? !this.myUserKey.equals(jiraUser.myUserKey) : jiraUser.myUserKey != null);
        }

        public int hashCode() {
            return this.myUserKey != null ? this.myUserKey.hashCode() : 0;
        }
    }

    @XmlRootElement
    public static class Anyone
    extends PermissionSubject
    implements Serializable {
        @Override
        public boolean matches(ApplicationUser user) {
            return true;
        }

        @Override
        public String toEncodedString() {
            return "anyone";
        }

        public boolean equals(Object obj) {
            return obj instanceof Anyone;
        }

        @Override
        public <T> T visit(Visitor<T> visitor, T carry) {
            return visitor.onAnyone(this, carry);
        }

        public int hashCode() {
            return Anyone.class.hashCode();
        }
    }
}

