/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.JiraFunc;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class CoreIdentities {
    public static final String ANONYMOUS_USER_ID = "-";
    public static final ItemIdentity NEW_ISSUE = CoreIdentities.issue(Long.MAX_VALUE);
    public static final ItemIdentity NEW_FOLDER = CoreIdentities.folder(Long.MAX_VALUE);
    public static final ItemIdentity NEW_GENERATOR = CoreIdentities.generator(Long.MAX_VALUE);
    public static final ItemIdentity NEW_EFFECTOR = CoreIdentities.effector(Long.MAX_VALUE);
    public static final ItemIdentity MISSING_ITEM = ItemIdentity.longId("com.almworks.jira.structure:type-missing", 0L);

    private CoreIdentities() {
    }

    public static ItemIdentity user(@Nullable ApplicationUser user) {
        return CoreIdentities.user(user == null ? null : user.getKey());
    }

    public static ItemIdentity user(@Nullable String userKey) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-user", userKey == null ? ANONYMOUS_USER_ID : userKey);
    }

    public static ItemIdentity group(@NotNull String groupId) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-group", groupId);
    }

    public static ItemIdentity group(@NotNull Group group) {
        return CoreIdentities.group(group.getName());
    }

    public static ItemIdentity project(Project value) {
        return CoreIdentities.project(value.getId());
    }

    public static ItemIdentity project(long projectId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project", projectId);
    }

    public static ItemIdentity priority(String id) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-priority", id);
    }

    public static ItemIdentity priority(Priority value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-priority", value.getId());
    }

    public static ItemIdentity status(String id) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-status", id);
    }

    public static ItemIdentity status(Status value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-status", value.getId());
    }

    public static ItemIdentity resolution(String id) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-resolution", id);
    }

    public static ItemIdentity resolution(Resolution value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-resolution", value.getId());
    }

    public static ItemIdentity label(String label) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-label", label);
    }

    public static ItemIdentity label(Label value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-label", value.getLabel());
    }

    public static ItemIdentity issueType(String id) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-issuetype", id);
    }

    public static ItemIdentity issueType(IssueType value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-issuetype", value.getId());
    }

    public static ItemIdentity issue(long issueId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue", issueId);
    }

    public static ItemIdentity issue(Issue issue) {
        return CoreIdentities.issue(issue.getId());
    }

    public static ItemIdentity version(@NotNull Version version) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-version", version.getId());
    }

    public static ItemIdentity version(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-version", id);
    }

    public static ItemIdentity versionName(String name) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-version-name", CoreIdentities.canonicalVersionName(name));
    }

    public static ItemIdentity versionName(@NotNull Version version) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-version-name", JiraFunc.CANONICAL_VERSION_NAME.la(version));
    }

    public static ItemIdentity generator(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-generator", id);
    }

    public static ItemIdentity effector(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-effector", id);
    }

    public static ItemIdentity loopMarker(long rowId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-loop-marker", rowId);
    }

    public static ItemIdentity component(ProjectComponent component) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project-component", component.getId());
    }

    public static ItemIdentity component(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project-component", id);
    }

    public static ItemIdentity option(Option option) {
        Long optionId = option.getOptionId();
        return optionId == null ? null : ItemIdentity.longId("com.almworks.jira.structure:type-cf-option", optionId);
    }

    public static ItemIdentity option(long optionId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-cf-option", optionId);
    }

    public static ItemIdentity structure(long structureId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-structure", structureId);
    }

    public static ItemIdentity sprint(long sprintId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-sprint", sprintId);
    }

    public static ItemIdentity tempoAccount(int accountId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-tempo-account", accountId);
    }

    public static ItemIdentity i18nFolder(@NotNull String i18nKey) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-folder", i18nKey);
    }

    public static ItemIdentity textFolder(@NotNull String text) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-folder", "/" + text);
    }

    public static ItemIdentity folder(long folderId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-folder", folderId);
    }

    public static ItemIdentity memo(long memoId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-memo", memoId);
    }

    public static ItemIdentity planningTask(long planningTaskId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-planning-task", planningTaskId);
    }

    @Deprecated
    public static ItemIdentity artificialTask(long artificialTaskId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-planning-task", artificialTaskId);
    }

    public static ItemIdentity sdRequestType(int requestTypeId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-sd-request-type", requestTypeId);
    }

    public static ItemIdentity insightObject(long objectId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-insight-object", objectId);
    }

    public static ItemIdentity projectCategory(long projectCategoryId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project-category", projectCategoryId);
    }

    public static ItemIdentity projectCategory(@NotNull ProjectCategory projectCategory) {
        return CoreIdentities.projectCategory(projectCategory.getId());
    }

    public static ItemIdentity attachment(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-attachment", id);
    }

    public static ItemIdentity attachment(@NotNull Attachment attachment) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-attachment", attachment.getId());
    }

    public static ItemIdentity comment(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-comment", id);
    }

    public static ItemIdentity comment(@NotNull Comment comment) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-comment", comment.getId());
    }

    public static ItemIdentity worklog(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-worklog", id);
    }

    public static ItemIdentity worklog(@NotNull Worklog worklog) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-worklog", worklog.getId());
    }

    public static ItemIdentity changeHistoryGroup(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-change-history-group", id);
    }

    public static ItemIdentity changeHistoryGroup(@NotNull ChangeHistory changeHistory) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-change-history-group", changeHistory.getId());
    }

    public static ItemIdentity changeHistoryItem(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-change-history-item", id);
    }

    public static ItemIdentity memoChangeHistoryGroup(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-memo-change-history-group", id);
    }

    public static ItemIdentity issueLink(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue-link", id);
    }

    public static ItemIdentity issueLink(@NotNull IssueLink issueLink) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue-link", issueLink.getId());
    }

    public static ItemIdentity issueLinkType(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue-link-type", id);
    }

    public static ItemIdentity issueLinkType(@NotNull IssueLinkType issueLinkType) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue-link-type", issueLinkType.getId());
    }

    public static boolean isIssue(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-issue");
    }

    public static boolean isProject(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-project");
    }

    public static boolean isComponent(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-project-component");
    }

    public static boolean isVersion(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-version");
    }

    public static boolean isGenerator(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-generator");
    }

    public static boolean isEffector(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-effector");
    }

    public static boolean isAutomation(ItemIdentity itemId) {
        return CoreIdentities.isGenerator(itemId) || CoreIdentities.isEffector(itemId);
    }

    public static boolean isStructure(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-structure");
    }

    public static boolean isLoopMarker(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-loop-marker");
    }

    public static boolean isTempoAccount(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-tempo-account");
    }

    public static boolean isVersionName(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-version-name");
    }

    public static boolean isAttachment(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-attachment");
    }

    public static boolean isComment(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-comment");
    }

    public static boolean isWorklog(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-worklog");
    }

    public static boolean isChangeHistoryGroup(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-change-history-group");
    }

    public static boolean isChangeHistoryItem(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-change-history-item");
    }

    public static boolean isMemoChangeHistoryGroup(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-memo-change-history-group");
    }

    public static boolean isIssueLink(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-issue-link");
    }

    public static boolean isIssueLinkType(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-issue-link-type");
    }

    public static boolean isFolder(ItemIdentity itemId) {
        return CoreIdentities.isItemType(itemId, "com.almworks.jira.structure:type-folder");
    }

    public static boolean isMemo(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-memo");
    }

    @Deprecated
    public static boolean isArtificialTask(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-planning-task");
    }

    public static boolean isPlanningTask(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-planning-task");
    }

    public static boolean isStatus(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-status");
    }

    public static boolean isUser(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-user");
    }

    public static boolean isPriority(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-priority");
    }

    public static boolean isResolution(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-resolution");
    }

    public static boolean isOption(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-cf-option");
    }

    public static boolean isGroup(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-group");
    }

    public static boolean isSprint(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-sprint");
    }

    public static boolean isLabel(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-label");
    }

    public static boolean isIssueType(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-issuetype");
    }

    public static String canonicalVersionName(String versionName) {
        if (versionName == null) {
            return null;
        }
        String version = versionName.trim().toLowerCase(Locale.ROOT);
        return version.length() > 190 ? version.substring(0, 190) : version;
    }

    private static boolean isStringType(@Nullable ItemIdentity itemId, @NotNull String itemType) {
        return CoreIdentities.isItemType(itemId, itemType) && itemId.isStringId();
    }

    private static boolean isLongType(@Nullable ItemIdentity itemId, @NotNull String itemType) {
        return CoreIdentities.isItemType(itemId, itemType) && itemId.isLongId();
    }

    private static boolean isItemType(@Nullable ItemIdentity itemId, @NotNull String itemType) {
        return itemId != null && itemType.equals(itemId.getItemType());
    }
}

