/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.atlassian.annotations.PublicApi;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class AttributeSpecBuilder<T> {
    private String myId;
    private ValueFormat<T> myFormat;
    private ParamsBuilder<AttributeSpecBuilder<T>> myParams;

    @NotNull
    public static AttributeSpecBuilder<Void> create() {
        return new AttributeSpecBuilder<Void>();
    }

    @NotNull
    public static AttributeSpecBuilder<Void> create(@Nullable String id) {
        return new AttributeSpecBuilder().setId(id);
    }

    @NotNull
    public static <T> AttributeSpecBuilder<T> create(@Nullable String id, @Nullable ValueFormat<T> format) {
        return new AttributeSpecBuilder<T>().setId(id).setFormat(format);
    }

    @NotNull
    public static <T> AttributeSpecBuilder<T> create(@Nullable String id, @Nullable ValueFormat<T> format, @Nullable Map<String, Object> params) {
        return new AttributeSpecBuilder<T>().setId(id).setFormat(format).params().copyFrom(params).done();
    }

    public static <T> AttributeSpecBuilder<T> create(AttributeSpec<T> sample) {
        if (sample == null) {
            return new AttributeSpecBuilder<T>();
        }
        return AttributeSpecBuilder.create(sample.getId(), sample.getFormat(), sample.getParamsMap());
    }

    @NotNull
    public AttributeSpec<T> build() {
        return new AttributeSpec<T>(this.myId, this.myFormat, this.myParams == null ? null : ((ParamsBuilder)this.myParams).buildMap(), true);
    }

    public AttributeSpecBuilder<T> setId(String id) {
        this.myId = id;
        return this;
    }

    public <R> AttributeSpecBuilder<R> setFormat(ValueFormat<R> format) {
        this.myFormat = format;
        return this;
    }

    public ParamsBuilder<AttributeSpecBuilder<T>> params() {
        if (this.myParams == null) {
            this.myParams = new ParamsBuilder<AttributeSpecBuilder>(this);
        }
        return this.myParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSpecBuilder that = (AttributeSpecBuilder)o;
        if (this.myId != null ? !this.myId.equals(that.myId) : that.myId != null) {
            return false;
        }
        if (this.myFormat != null ? !this.myFormat.equals(that.myFormat) : that.myFormat != null) {
            return false;
        }
        return !(this.myParams == null ? that.myParams != null : !this.myParams.equals(that.myParams));
    }

    public int hashCode() {
        int result = this.myId != null ? this.myId.hashCode() : 0;
        result = 31 * result + (this.myFormat != null ? this.myFormat.hashCode() : 0);
        result = 31 * result + (this.myParams != null ? this.myParams.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AttributeSpecBuilder('" + this.myId + "', " + this.myFormat + ", " + this.myParams + ")";
    }

    public class ParamsBuilder<P> {
        private final P myParent;
        private final Map<String, Object> myParams = new LinkedHashMap<String, Object>();

        ParamsBuilder(P parent) {
            this.myParent = parent;
        }

        public P done() {
            return this.myParent;
        }

        public ParamsBuilder<P> remove(String key) {
            this.myParams.remove(key);
            return this;
        }

        public ParamsBuilder<ParamsBuilder<P>> object(String key) {
            ParamsBuilder<ParamsBuilder> r;
            Object existing = this.myParams.get(key);
            if (existing instanceof ParamsBuilder) {
                r = (ParamsBuilder<ParamsBuilder>)existing;
            } else {
                r = new ParamsBuilder<ParamsBuilder>(this);
                this.put(key, r);
            }
            return r;
        }

        public ParamsBuilder<P> set(String key, Object value) {
            if (value == null) {
                return this;
            }
            if (value instanceof AttributeSpec) {
                return this.setAttribute(key, (AttributeSpec)value);
            }
            JsonMapUtil.checkValidParameter(value);
            return this.setValidated(key, value);
        }

        public ParamsBuilder<P> setAttribute(AttributeSpec<?> value) {
            return this.setAttribute("attribute", value);
        }

        public ParamsBuilder<P> setAttribute(String key, AttributeSpec<?> value) {
            return super.setValidatedMap("params", value.getParamsMap()).done();
        }

        public ParamsBuilder<P> copyFrom(@Nullable Map<String, Object> map) {
            if (map == null || map.isEmpty()) {
                return this;
            }
            JsonMapUtil.checkValidParameter(map);
            return this.copyFromValidated(map);
        }

        public AttributeSpec<T> build() {
            return AttributeSpecBuilder.this.build();
        }

        private ParamsBuilder<P> setValidated(String key, Object value) {
            if (value instanceof Map) {
                return this.setValidatedMap(key, (Map)value);
            }
            this.put(key, value);
            return this;
        }

        private ParamsBuilder<P> setValidatedMap(String key, Map<String, Object> map) {
            if (map == null || map.isEmpty()) {
                return this;
            }
            return super.copyFromValidated(map).done();
        }

        @NotNull
        private ParamsBuilder<P> copyFromValidated(Map<String, Object> map) {
            if (map != null) {
                for (Map.Entry<String, Object> e : map.entrySet()) {
                    this.setValidated(e.getKey(), e.getValue());
                }
            }
            return this;
        }

        private void put(String key, Object r) {
            if (key == null) {
                throw new IllegalArgumentException("null key is not allowed");
            }
            this.myParams.put(key, r);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamsBuilder that = (ParamsBuilder)o;
            return this.myParams.equals(that.myParams);
        }

        public int hashCode() {
            return this.myParams.hashCode();
        }

        public String toString() {
            return this.myParams.toString();
        }

        @Nullable
        private Map<String, Object> buildMap() {
            if (this.myParams.isEmpty()) {
                return null;
            }
            LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>(this.myParams);
            Iterator<Map.Entry<String, Object>> ii = r.entrySet().iterator();
            while (ii.hasNext()) {
                Map.Entry<String, Object> e = ii.next();
                Map<String, Object> value = e.getValue();
                if (!(value instanceof ParamsBuilder)) continue;
                if ((value = ((ParamsBuilder)((Object)value)).buildMap()) == null) {
                    ii.remove();
                    continue;
                }
                e.setValue(value);
            }
            return r;
        }
    }
}

