/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class AttributeErrorInfo {
    private final AttributeSpec<?> myAttributeSpec;
    private final Long myRowId;
    private final ItemIdentity myItemId;
    private final Throwable myCause;

    public AttributeErrorInfo(@NotNull AttributeSpec<?> attributeSpec, @Nullable Long rowId, @Nullable ItemIdentity itemId, @Nullable Throwable cause) {
        this.myAttributeSpec = attributeSpec;
        this.myRowId = rowId;
        this.myItemId = itemId;
        this.myCause = cause;
    }

    @NotNull
    public AttributeSpec<?> getAttributeSpec() {
        return this.myAttributeSpec;
    }

    @Nullable
    public Long getRowId() {
        return this.myRowId;
    }

    @Nullable
    public ItemIdentity getItemId() {
        return this.myItemId;
    }

    @Nullable
    public Throwable getCause() {
        return this.myCause;
    }

    public String toString() {
        StringBuilder r = new StringBuilder().append("problem:").append(this.myAttributeSpec);
        if (this.myRowId != null) {
            r.append(":row=").append(this.myRowId);
        }
        if (this.myItemId != null) {
            r.append(":item=").append(this.myItemId);
        }
        if (this.myCause != null) {
            r.append(":").append(this.myCause.getMessage());
        }
        return r.toString();
    }
}

