package com.almworks.jira.structure.api.settings;

/**
 * Attribute sensitivity mode defines the default sensitivity of attributes. See {@link AttributeSensitivitySettings} for details.
 */
public enum AttributeSensitivityMode {
  /**
   * Standard sensitivity mode allows unfiltered access to numeric and date values for aggregation.
   */
  STANDARD(0),

  /**
   * Strict sensitivity mode does not allow unfiltered access to any attribute.
   */
  STRICT(1),

  /**
   * Permissive sensitivity mode allows unfiltered access to any attribute for aggregation.
   */
  PERMISSIVE(2);

  private final int myCode;

  AttributeSensitivityMode(int code) {
    myCode = code;
  }

  /**
   * Returns the code for the mode. This code should be used when serializing the setting.
   *
   * @return code
   */
  public int getCode() {
    return myCode;
  }

  /**
   * Returns the mode associated with the given code
   *
   * @param value mode code
   * @return mode
   * @throws IllegalArgumentException if there's no mode with the given code
   */
  public static AttributeSensitivityMode valueOf(int value) {
    for (AttributeSensitivityMode mode : AttributeSensitivityMode.values()) {
      if (mode.getCode() == value) {
        return mode;
      }
    }
    throw new IllegalArgumentException(value + " is not a valid sensitivity mode code");
  }
}
