package com.almworks.jira.structure.api.rest.effect;

import com.almworks.jira.structure.api.forest.action.AppliedEffect;
import com.almworks.jira.structure.api.forest.action.AppliedEffectBatch;
import com.atlassian.annotations.Internal;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@Internal
@XmlRootElement
public class RestEffectBatch {
  @XmlElement
  public long batchId;

  @XmlElement
  public List<RestEffect> effects;

  public static RestEffectBatch fromAppliedBatch(AppliedEffectBatch batch) {
    RestEffectBatch reb = new RestEffectBatch();
    reb.batchId = batch.getBatchId();
    reb.effects = new ArrayList<>(batch.getEffects().size());
    for (AppliedEffect effect : batch.getEffects()) {
      reb.effects.add(RestEffect.fromAppliedEffect(effect));
    }
    return reb;
  }
}
