package com.almworks.jira.structure.api.property;

import com.almworks.jira.structure.api.util.StructureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

/**
 * Holds properties associated with the particular structure
 *
 */
public interface StructurePropertyService {

  @Nullable
  String getString(long structureId, @NotNull String key, @Nullable String defaultValue);

  default long getLong(long structureId, @NotNull String key, long defaultValue) {
    return StructureUtil.lv(getString(structureId, key, null), defaultValue);
  }
  /**
   * Stores value for the given structure and key
   *
   * Notes:
   *  1. There is no structure existence or permissions checks
   *  2. Existing values will be overridden
   *  3. setting 'null' will remove database entry
   *
   * @param structureId id of the structure, structure may not exist
   * @param key should be <= 170 chars in length
   * @param value length is not limited, but specific DB rules for storing long text values may apply
   * */
  void setValue(long structureId, @NotNull String key, @Nullable String value);

  default void setValue(long structureId, @NotNull String key, long value) {
    setValue(structureId, key, String.valueOf(value));
  }

  @NotNull
  Set<String> getAllKeys(long structureId);

  void removeAllProperties(long structureId);
}
