package com.almworks.jira.structure.api.job;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is the basic implementation of a structure job, that should be extended by the actual job code.
 * This class implements most of the housekeeping methods.
 *
 * @author Igor Sereda
 * todo actually move most of the StructureJob methods to under the implementation (implement lifecycle in a peer class)
 */
public abstract class AbstractStructureJob implements StructureJob {
  private static final Logger logger = LoggerFactory.getLogger(AbstractStructureJob.class);
  
  protected final Object myLock = new Object();
  private State myState = State.PENDING;

  public final State getState() {
    synchronized (myLock) {
      return myState;
    }
  }

  public String toString() {
    return getClass().getName() + "(" + myState + ")";
  }

  private void setState(State oldState, State state) {
    synchronized (myLock) {
      if (myState == oldState) {
        myState = state;
      } else {
        logger.warn(this + ": state inconsistency, expected " + oldState + " actual " + myState);
      }
    }
  }

  public void reset() {
    synchronized (myLock) {
      if (myState == State.RUNNING) {
        logger.warn("resetting state of a running job " + this);
      }
      myState = State.PENDING;
    }
  }

  public final void job() throws Exception {
    setState(State.PENDING, State.RUNNING);
    try {
      doJob();
    } finally {
      setState(State.RUNNING, State.FINISHED);
    }
  }

  protected abstract void doJob() throws Exception;
}
