package com.almworks.jira.structure.api.forest.raw;

import com.almworks.integers.LongList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Implement this interface to efficiently process a forest in a bottom-up style with {@link Forest#foldUpwards}.
 *
 * @param <T> the type of the result of processing one row
 * @param <C> the type of the result of processing a number of sub-rows under the same parent
 */
public interface ForestParentChildrenClosure<T, C> {
  /**
   * Used to combine values returned by {#visitRow} calls to every sub-row of a single parent.
   *
   * @param fold fold control
   * @param value the value returned by {@code visitRow()}
   * @param carry the carry value returned by previous call to {@code combine()} on a result of processing the successor row under the same parent row, or {@code null} for the first call
   * @return the combined carry value
   */
  @Nullable
  C combine(@NotNull ForestIterationControl fold, T value, @Nullable C carry);

  /**
   * Process an row using information about children.
   *
   * @param fold fold control
   * @param row the row id
   * @param children the sub-rows, or empty list if it's a leaf
   * @param carry the combined carry value (result of calling {@link #combine} on every result of child processing, or null if (but not only if) there are no children
   * @return the result of processing
   */
  @Nullable
  T visitRow(@NotNull ForestIterationControl fold, long row, @NotNull LongList children, @Nullable C carry);
}
