package com.almworks.jira.structure.api.export.excel;

import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.export.ExportCell;
import com.almworks.jira.structure.api.export.ExportContextKeys;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * <p>{@code ExcelCell} is a specialization of {@link ExportCell} for exporting to the Microsoft Excel format, offering
 * limited support for Excel-specific styling.</p>
 *
 * <p>Excel export is backed by Apache POI. For advanced formatting you can call the underlying POI objects directly,
 * obtaining them from the column context.</p>
 *
 * @see ExcelColumn
 * @see AttributeContext#getObject(Object)
 * @see ExportContextKeys.Excel
 */
@PublicApi
public interface ExcelCell extends ExportCell {
  /**
   * Attempts to convert an HTML fragment into a rich text string and set that as the cell value. The conversion used is
   * very primitive, at present it only supports {@code &lt;b&gt;}, {@code &lt;i&gt;}, {@code &lt;em&gt;}, and
   * {@code &lt;strong&gt;} HTML tags. If the passed HTML fragment is invalid, it may be treated as a literal string.
   *
   * @param html The HTML fragment.
   */
  void setRichTextFromHtml(@Nullable String html);

  /**
   * Set the cell style. The style is very important for the correct display of your values, as it determines the cell's
   * value format, alignment, font, and color. For most value types it is expected that you set the data cell style
   * accordingly. We recommend you to use {@link ExcelColumn#setDefaultStyle(ExcelStyle)} once instead of setting the
   * same style to each data cell. It is OK to use {@code setStyle()} for column header cells.
   *
   * @param style The style.
   */
  void setStyle(@Nullable ExcelStyle style);

  /**
   * Set the indentation level for the cell. This is used by Structure's Summary column to show an issue's depth within
   * the structure. Indentation levels over 15 cannot be represented due to Excel format limitations.
   *
   * @param indention The indentation level, clamped to be between 0 and 15, inclusive.
   */
  void setIndention(int indention);
}
