package com.almworks.jira.structure.api.export;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * <p>
 *   A context that is passed to {@link ExportRenderer} and {@link ExportRendererProvider} during preparation
 *   phase of the export.
 * </p>
 * <p>
 *   The main capability of this interface is to allow the renderer to request calculation of specific attributes
 *   via {@link #requireAttribute} methods. These attributes will be available later during the main phase of the
 *   export.
 * </p>
 * <p>Additionally, a renderer may prepare some data and store it in the context.</p>
 * 
 * @see AttributeContext
 * @see ExportRenderContext
 */
@PublicApi
public interface ExportRequestContext extends AttributeContext {
  /**
   * <p>Require an attribute to be calculated for this request. The values can later be
   * retrieved from {@link ExportRow#get(AttributeSpec)} or {@link ExportRenderContext#getValues()}.</p>
   *
   * @param attribute The attribute specification. Passing {@code null} allowed and has no effect.
   *
   * @see ExportRow#get(AttributeSpec)
   * @see ExportRenderContext#getValues()
   * @see AttributeSpec
   */
  void requireAttribute(@Nullable AttributeSpec<?> attribute);

  /**
   * Returns the forest spec being exported.
   */
  @NotNull
  ForestSpec getForestSpec();
}
