package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * Represents a map of values, with one value per key.
 *
 * @param <K> either {@code Long} (for rows) or {@link ItemIdentity} for items
 * @param <T> type of value
 */
@PublicApi
public interface ValueColumn<K, T> {
  /**
   * Returns the value for the given key.
   *
   * @param key the key
   * @return value or {@code null} if the value has not been calculated
   */
  @Nullable
  LoadedValue<T> getValue(@Nullable K key);

  static <K, T> ValueColumn<K, T> empty() {
    return row -> null;
  }
}
