package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;

@Internal
final class UpToDateLoadedValue<T> implements LoadedValue<T> {
  @NotNull
  private final AttributeValue<T> myValue;

  public UpToDateLoadedValue(@NotNull AttributeValue<T> value) {
    myValue = value;
  }

  @NotNull
  @Override
  public AttributeValue<T> getValue() {
    return myValue;
  }

  @Override
  public boolean isOutdated() {
    return false;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UpToDateLoadedValue<?> upToDate = (UpToDateLoadedValue<?>) o;
    return Objects.equals(myValue, upToDate.myValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(myValue);
  }

  @Override
  public String toString() {
    return String.valueOf(myValue);
  }
}
