package com.almworks.jira.structure.api.sync.util;

import com.almworks.jira.structure.api.util.IndexedForest;
import com.almworks.jira.structure.api.util.LongListHashIndex;
import com.carrotsearch.hppc.IntIntOpenHashMap;

public class HierarchyHelper {
  private final LongListHashIndex myIndex;
  private final IndexedForest myIndexedForest;
  private final IntIntOpenHashMap myMovedIdxs = new IntIntOpenHashMap();

  public HierarchyHelper(LongListHashIndex index, IndexedForest indexedForest) {
    myIndex = index;
    myIndexedForest = indexedForest;
  }

  public void recordMove(long row, long newParent) {
    recordMove(myIndex.indexOf(row), myIndex.indexOf(newParent));
  }

  private void recordMove(int idx, int newParentIdx) {
    myMovedIdxs.put(idx, newParentIdx);
  }

  public long getParent(long row) {
    int parentIndex = getParentIndex(row);
    return parentIndex != -1 ? myIndexedForest.row(parentIndex) : 0;
  }

  private int getParentIndex(long row) {
    return getParentIndex(myIndex.indexOf(row));
  }

  private int getParentIndex(int idx) {
    if (idx == -1) throw new IllegalArgumentException("index is not in the forest");
    return myMovedIdxs.containsKey(idx) ? myMovedIdxs.lget() : myIndexedForest.parent(idx);
  }

  public boolean isInSubtree(long row, long subtreeOwner) {
    if (row == 0L) return false;
    if (subtreeOwner == 0L) return true;
    return isInSubtree(myIndex.indexOf(row), myIndex.indexOf(subtreeOwner));
  }

  private boolean isInSubtree(int idx, int subtreeOwnerIdx) {
    if (idx == -1) throw new IllegalArgumentException("index is not in the forest");
    if (subtreeOwnerIdx == -1) throw new IllegalArgumentException("subtreeOwnerIdx is not in the forest");

    int parentIdx = getParentIndex(idx);
    while (parentIdx >= 0) {
      if (parentIdx == subtreeOwnerIdx) {
        return true;
      }
      parentIdx = getParentIndex(parentIdx);
    }
    return false;
  }
}
