package com.almworks.jira.structure.api.structure.history;

/**
 * Same principle as {@link HistoryConsumer}.
 * Used in the context of querying history while limiting the number of changes that are loaded per {@link HistoryEntry}.
 * */
public interface LimitedHistoryConsumer {
  /**
   * Consume streamed {@link HistoryEntry} with the total number of changes associated with it.
   * @param entry history entry.
   * @param changesCount total number of changes associated with {@code entry}.
   *                     this value will differ from {@code entry.getChanges().size()} when the query uses changes limit and the limit is
   *                     surpassed for a given entry.
   * @return boolean tells the user of this consumer to continue (true) or stop (false) providing data.
   * */
  boolean consume(HistoryEntry entry, int changesCount);

}
