package com.almworks.jira.structure.api.forest.raw;

import com.almworks.integers.IntList;
import com.almworks.integers.LongList;

/**
 * Lets an iteratee under {@link Forest#scanDownwards} control the iteration and receive additional information
 * about the current position. Using methods provided by this class provides linear-speed iteration in many cases.
 */
public interface ForestScanControl extends ForestIterationControl {
  /**
   * @return parent of the current row, or 0 if the current row is a root
   */
  long getParent();

  /**
   * @return index of the parent of the current row, or -1 if the current row is a root
   */
  int getParentIndex();

  /**
   * Skips the subtree rooted at the current row.
   *
   * @return the index of the next row to be iterated
   * @see Forest#getSubtreeEnd
   */
  int skipSubtree();

  /**
   * Skips the rest of the subtree rooted at one of the ancestor rows.
   *
   * @param depth the depth of the ancestor, must be equal or less than the depth of the current row. When {@code depth}
   * is equal to the current row's depth, the result is equal to {@link #skipSubtree}. If {@code depth} is {@code -1},
   * iteration skips to the end of the forest (thus ending the iteration).
   *
   * @return the index of the next row to be iterated
   */
  int skipParentSubtree(int depth);

  /**
   * @return rows from the subtree rooted at the current row, including the row itself.
   */
  LongList getSubtreeRows();

  /**
   * @return a list of indexes or rows that constitute current row's parent path. 0-th element is the index of the
   * forest root, and the last element is the current index.
   */
  IntList getParentPathIndexes();
}
