package com.almworks.jira.structure.api.forest.raw;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>This is a utility implementation of {@link ForestParentChildrenClosure} that collects the results
 * of processing sub-rows into a list. This list is then passed to {@link #visitRow} as a children carry.</p>
 *
 * <p>Note that the list passed to {@code visitRow()} is in the <strong>reverse order</strong>, that is,
 * the first result is for the last child row.</p>
 */
public abstract class ForestParentChildrenListClosure<T> implements ForestParentChildrenClosure<T, List<T>> {
  private final List<List<T>> myCarryStack = new ArrayList<>();

  public List<T> combine(@NotNull ForestIterationControl fold, @NotNull T value, @Nullable List<T> carry) {
    int depth = fold.getDepth();
    if (carry == null) {
      while (myCarryStack.size() <= depth) {
        myCarryStack.add(new ArrayList<T>(5));
      }
      carry = myCarryStack.get(depth);
      carry.clear();
    }
    carry.add(value);
    return carry;
  }
}
