package com.almworks.jira.structure.api.export.printable;

import com.almworks.jira.structure.api.export.ExportCell;
import com.almworks.jira.structure.api.export.ExportColumn;
import com.atlassian.annotations.PublicApi;

/**
 * {@code PrintableColumn} is a specialization of {@link ExportColumn} for exporting to the printable HTML format.
 *
 * @see PrintableCell
 */
@PublicApi
public interface PrintableColumn extends ExportColumn<PrintableCell> {
  /**
   * Pass {@code true} to this method to allow line breaks for the cells in this column. By default line breaks are
   * forbidden (by using a {@code "white-space: nowrap !important"} CSS declaration).
   *
   * @param multiline {@code true} if line breaks are allowed, {@code false} otherwise.
   */
  void setMultiline(boolean multiline);

  /**
   * Set the percentage display style for the cells in this column. {@link PercentageStyle#PROGRESS_BAR} is used when
   * no other style is set.
   *
   * @param style The percentage style.
   *
   * @see ExportCell#setPercentage(Double)
   */
  void setPercentageStyle(PercentageStyle style);

  /**
   * A true value specifies that JIRA time tracking settings (number of work hours per day and work days per week)
   * should not be used when converting duration to friendly text (in days and weeks).
   *
   * @param durationAsCalendarTime duration formatting mode
   */
  void setDurationAsCalendarTime(boolean durationAsCalendarTime);
}