package com.almworks.jira.structure.api.cache.scope;

import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.atlassian.annotations.Internal;

@Internal
public interface ProjectScopeCache {
  /**
   * Collects out-of-scope issues, i.e. issues belonging to projects for which Structure is not enabled.
   * Uses Lucene index and caching to speed up the checks.
   *
   * @param issues Issue IDs to check.
   * @param collector Collector to receive out-of-scope issue IDs. It's safe for the collector to modify
   * the {@code issues} collection, because the implementation copies it.
   */
  void collectOutOfScopeIssues(LongIterable issues, LongCollector collector);
}
