package com.almworks.jira.structure.api.attribute.loader.delegate;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public abstract class DelegatingAttributeLoader<T, L extends AttributeLoader<T>> implements AttributeLoader<T> {
  @NotNull
  private final L myLoader;

  protected DelegatingAttributeLoader(@NotNull L loader) {
    //noinspection ConstantConditions
    if (loader == null) throw new NullPointerException();
    myLoader = loader;
  }

  @NotNull
  protected L delegate() {
    return myLoader;
  }

  @Override
  @NotNull
  public AttributeSpec<T> getAttributeSpec() {
    return delegate().getAttributeSpec();
  }

  @Override
  @Nullable
  public Set<AttributeSpec<?>> getAttributeDependencies() {
    return delegate().getAttributeDependencies();
  }

  @Override
  @Nullable
  public Set<AttributeContextDependency> getContextDependencies() {
    return delegate().getContextDependencies();
  }

  @Override
  @Nullable
  public AttributeCachingStrategy getCachingStrategy() {
    return delegate().getCachingStrategy();
  }

  @Override
  @Nullable
  public TrailItemSet getGlobalTrail() {
    return delegate().getGlobalTrail();
  }

  @Override
  public String toString() {
    return getClass().getName() + ":" + myLoader;
  }
}
