package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeContext;
import com.almworks.jira.structure.api.item.ItemIdentity;

import java.util.*;

// naive implementation - needs optimization
// non-naive implementation will require support from the system
public abstract class AbstractNaiveDistinctAggregateLoader<T> extends AbstractAggregateLoader<T> {
  public AbstractNaiveDistinctAggregateLoader(AttributeSpec<T> spec) {
    super(spec);
  }

  @Override
  public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AggregateAttributeContext context) {
    Map<ItemIdentity, T> values = new HashMap<>();
    for (AttributeValue<T> childValue : childrenValues) {
      if (childValue.isDefined()) {
        //noinspection unchecked
        Map<ItemIdentity, T> childData = childValue.getLoaderData(Map.class);
        if (childData != null) {
          values.putAll(childData);
        }
      }
    }
    ItemIdentity itemId = context.getRow().getItemId();
    if (!values.containsKey(itemId)) {
      T value = getRowValue(context);
      if (value != null) {
        values.put(itemId, value);
      }
    }
    T total = combine(values.values(), context);
    return AttributeValue.of(total).withData(Collections.unmodifiableMap(values));
  }

  protected abstract T getRowValue(RowAttributeContext context);

  protected abstract T combine(Collection<T> values, AggregateAttributeContext context);
}
