package com.almworks.jira.structure.api.util;

import org.jetbrains.annotations.NotNull;

public abstract class La2<A1, A2, R> extends La<A1, La<A2, R>> {
  public abstract R la(A1 a1, A2 a2);

  @Override
  public La<A2, R> la(final A1 a1) {
    return new La<A2, R>() {
      @Override
      public R la(A2 a2) {
        return La2.this.la(a1, a2);
      }
    };
  }

  public static <A1, A2, R> La2<A1, A2, R> uncurry(@NotNull final La<A1, La<A2, R>> curried) {
    return new La2<A1, A2, R>() {
      @Override
      public R la(A1 a1, A2 a2) {
        La<A2, R> f = curried.la(a1);
        return f == null ? null : f.la(a2);
      }
    };
  }

  public static <R> Const<R> const2(R ret) {
    return new Const<R>(ret);
  }
  
  public static <A2, R> Binder2<A2, R> bind2(La<A2, R> f) {
    return new Binder2<A2, R>(f);
  }

  public static final La2<Integer, Integer, Integer> sum = new La2<Integer, Integer, Integer>() {
    @Override
    public Integer la(Integer x, Integer y) {
      return x + y;
    }
  };  
  
  public static class Const<R> {
    private final R myR;

    public Const(R r) {
      myR = r;
    }
    
    public <A1, A2> La2<A1, A2, R> f() {
      return uncurry(La.<A1, La<A2, R>>constant(La.<A2, R>constant(myR)));
    }
  }
  
  public static class Binder2<A2, R> {
    private final La<A2, R> myF;

    public Binder2(La<A2, R> f) {
      myF = f;
    }

    public <A1> La2<A1, A2, R> create() {
      return new La2<A1, A2, R>() {
        @Override
        public R la(A1 a1, A2 a2) {
          return myF.la(a2);
        }
      };
    }
  }
}
