package com.almworks.jira.structure.api.template;

import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author alexeypegov
 */
public interface NewStructureTemplateStep {
  String END_STEP = "__end";
  String START_STEP = "__start";
  String CREATE_STRUCTURE = "__create"; // should be returned as a next step to trigger structure creation

  enum Direction {
    FORWARD,
    BACK;

    public boolean isBack() {
      return this == BACK;
    }
  }

  @NotNull
  String getTitleI18nKey();

  void validateStep(@NotNull Map<String, Object> params, @NotNull NewStructureTemplateContext context);

  @NotNull
  String getNextStep(@NotNull Map<String, Object> params, @NotNull Direction direction, @NotNull NewStructureTemplateContext context);
}
