package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.error.StructureRuntimeException;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilder;
import com.atlassian.annotations.PublicApi;

/**
 * <p>This exception is thrown by {@link RowManager} if the code requests a non-existent row. Since row IDs
 * may not appear from anywhere else except from the same {@code RowManager}, it is an unexpected error condition.</p>
 *
 * <p>Note: there are also negative row IDs that are used for temporary rows when building forest fragments &mdash;
 * see {@link ItemForestBuilder}. Usage of these row ID must be confined to the builder they came from. Trying to
 * retrieve rows with negative ID from {@code RowManager} would result in this exception.</p>
 *
 * @see RowManager
 */
@PublicApi
public class MissingRowException extends StructureRuntimeException {
  private final long myRowId;

  public MissingRowException(long rowId) {
    super("row " + rowId + " is not found");
    myRowId = rowId;
  }

  public long getRowId() {
    return myRowId;
  }
}
