package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.util.I18nText;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class ProcessDisplayParameters {
  private I18nText myName;
  private List<ProcessButtonParameters> myButtons;

  public ProcessDisplayParameters() {
    myButtons = newArrayList();
  }

  public ProcessDisplayParameters(ProcessDisplayParameters parameters) {
    myName = parameters.myName;
    myButtons = newArrayList(parameters.myButtons);
  }

  public I18nText getName() {
    return myName;
  }

  public void setName(I18nText name) {
    myName = name;
  }

  public List<ProcessButtonParameters> getButtons() {
    return myButtons;
  }

  public void setButtons(List<ProcessButtonParameters> buttons) {
    myButtons = buttons;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) { return false; }
    if (obj == this) { return true; }
    if (obj.getClass() != getClass()) {
      return false;
    }
    ProcessDisplayParameters rhs = (ProcessDisplayParameters) obj;
    return new EqualsBuilder()
      .append(this.myName, rhs.myName)
      .append(this.myButtons, rhs.myButtons)
      .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
      .append(myName)
      .append(myButtons)
      .toHashCode();
  }


  public static class Builder {
    private final ProcessDisplayParameters myInstance;

    public Builder() {
      myInstance = new ProcessDisplayParameters();
    }

    public Builder(ProcessDisplayParameters instance) {
      myInstance = new ProcessDisplayParameters(instance);
    }

    public Builder withProcessName(String nameKey, Object... args) {
      myInstance.myName = new I18nText(nameKey, args);
      return this;
    }

    public Builder addButton(String url, String captionKey, Object... args) {
      myInstance.myButtons.add(new ProcessButtonParameters(new I18nText(captionKey, args), url));
      return this;
    }

    public ProcessDisplayParameters build() {
      return myInstance;
    }
  }
}
