package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

@PublicApi
public interface GeneratorManager {
  long createGenerator(@NotNull String moduleKey, @Nullable Map<String, Object> parameters, @Nullable Long owningStructure) throws StructureException;

  long createTransientGenerator(@NotNull String moduleKey, @Nullable Map<String, Object> parameters) throws StructureException;

  void updateGenerator(long id, @NotNull String moduleKey, @Nullable Map<String, Object> parameters, @Nullable Long owningStructure) throws StructureException;

  void deleteGenerator(long id) throws StructureException;

  @NotNull
  GeneratorSpec getGenerator(long id) throws StructureException;
}
