package com.almworks.jira.structure.api.extension.license;

public enum StructureLicenseError {
  NO_ERROR(0),
  NO_LICENSE(1000),
  LICENSE_CERTIFICATE_ERROR(1001),
  VENDOR_CERTIFICATE_ERROR(1003),
  NOT_SIGNED(1004),
  NO_METADATA(1005),
  INVALID_DATE(1006),
  INVALID_NUMBER(1007),
  BAD_PRODUCT_ID(1008),
  EXPIRED(1009),
  NO_RELEASE_DATE(1010),
  UNSUPPORTED_VERSION(1011),
  UNSUPPORTED_SERVER(1012),
  JIRA_LICENSE_MISMATCH_USERS(1013),
  INVALID_PRODUCT(1014),
  FREE_LICENSE_EXPECTED(1015),
  BAD_CUSTOMER_ID(1016),
  REVOKED_LICENSE(1017),
  TYPE_MISMATCH(1018),
  UNKNOWN_ERROR(1019),
  JIRA_EVAL_LICENSE_MISMATCH(1020),
  NO_DATACENTER_SUPPORT(1021);

  private final long myCode;

  StructureLicenseError(long code) {
    myCode = code;
  }

  public long getCode() {
    return myCode;
  }
}
