package com.almworks.jira.structure.api.export;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * An enum representing the formats that a structure can be exported into.
 * @see ExportRendererProvider
 */
@PublicApi
public enum ExportFormat {
  /**
   * Printable page (HTML) format.
   */
  PRINTABLE("printable"),

  /**
   * Microsoft Excel (*.xls) format.
   */
  MS_EXCEL("ms-excel");

  private final String myExternalName;

  private ExportFormat(String externalName) {
    myExternalName = externalName;
  }

  /**
   * @return The external name for the format, as used in {@code atlassian-plugin.xml}.
   */
  @NotNull
  public String getExternalName() {
    return myExternalName;
  }

  /**
   * @param externalName The external name for the format, as used in {@code atlassian-plugin.xml}.
   * @return The {@code ExportFormat} instance corresponding to the given external name or {@code null} if none.
   */
  @Nullable
  public static ExportFormat forExternalName(String externalName) {
    for (ExportFormat ef : values()) {
      if (ef.myExternalName.equals(externalName)) {
        return ef;
      }
    }
    return null;
  }
}
