/**
 * <p>This package provides API for using attributes, a concept added by Structure platform for universal access
 * to item data.</p>
 *
 * <p>An <strong>attribute</strong> is something that can be calculated or retrieved for a structure row.
 * The data shown to the users in structure grid is based on attributes.</p>
 *
 * <p>An attribute is identified by {@link com.almworks.jira.structure.api.attribute.AttributeSpec}. To calculate
 * the values, client code passes {@link com.almworks.jira.structure.api.forest.ForestSpec}, row IDs and
 * attribute specifications to {@link com.almworks.jira.structure.api.attribute.StructureAttributeService} and
 * receives a matrix with values as a result.</p>
 *
 * <p>Attributes can be of three kinds:</p>
 *
 * <ul>
 *   <li><strong>Simple</strong> attributes are calculated based only on the row itself. For example,
 *   all issue fields are simple attributes.</li>
 *
 *   <li><strong>Aggregate</strong> attributes are calculated based on the row and its sub-rows. For example,
 *   a total over some numeric field is an aggregate.</li>
 *
 *   <li><strong>Propagate</strong> attributes are calculated in "top-down" manner: values for sub-rows are
 *   calculated based on the parent row. A numbered bullet index is an example of propagate attributes.</li>
 * </ul>
 *
 * <p>Attributes are extensible. The specific implementation of an attribute is provided by Structure itself or by
 * other add-ons. It is therefore important to notice that if an add-on is installed or uninstalled, the implementation
 * of some attributes may change. For the SPI, see {@link com.almworks.jira.structure.api.attribute.loader} package.</p>
 *
 * <p><strong>Note:</strong> It is important to differentiate attributes from columns. A column in Structure widget displays some
 * HTML to the user. It usually requires one or more attributes to be loaded, it then takes attribute values
 * and displays them somehow (sometimes as-is, sometimes not &mdash; for example, <em>Icons</em> column can
 * display concatenated icons, loaded through several attributes.</p>
 */
package com.almworks.jira.structure.api.attribute;