package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;

public abstract class SingleDependencyReducingAggregateLoader<T> extends ReducingAggregateLoader<T> {
  protected final AttributeSpec<T> myDependency;

  protected SingleDependencyReducingAggregateLoader(AttributeSpec<T> spec, AttributeSpec<T> dependency) {
    super(spec);
    myDependency = dependency;
  }

  @NotNull
  @Override
  protected AttributeValue<T> getSelfValue(AttributeLoader.AggregateContext<T> context) {
    AttributeValue<T> value = context.getAttributeValue(myDependency);
    return value != null ? value : AttributeValue.undefined();
  }

  @NotNull
  @Override
  public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myDependency);
  }
}
