package com.almworks.jira.structure.api.attribute.loader.distinct;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.CoreAttributeSpecs;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.basic.NumberAccumulator;
import org.jetbrains.annotations.NotNull;

public class DistinctNumberSumLoader extends AbstractDistinctSumLoader<Number, Number, NumberAccumulator> {
  public DistinctNumberSumLoader(AttributeSpec<Number> spec, AttributeSpec<Number> dependentAttribute) {
    super(spec, spec.withParam(CoreAttributeSpecs.Param.DISTINCT, Boolean.FALSE), dependentAttribute);
  }

  @Override
  protected NumberAccumulator initializeWithNonDistinctValue(Number value) {
    if (value == null) return null;
    NumberAccumulator accumulator = new NumberAccumulator();
    accumulator.add(value);
    return accumulator;
  }

  @Override
  @NotNull
  protected NumberAccumulator removeDuplicates(@NotNull NumberAccumulator before, @NotNull Number argument, int extraInstancesCount) {
    before.removeMultiply(argument, extraInstancesCount);
    return before;
  }

  @Override
  protected AttributeValue<Number> finalize(NumberAccumulator value) {
    return value.toValue();
  }
}
