package com.almworks.jira.structure.api.attribute.loader.distinct;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;

import java.util.Map;

@Internal
public class DistinctAttributes {
  public static final String NON_UNIQUE_ITEMS = "-non-unique-items";
  public static final String MAP_VALUES_FORMAT_ID = "values";
  public static final ValueFormat<Map> MAP_VALUES_FORMAT = new ValueFormat<>(MAP_VALUES_FORMAT_ID, Map.class);
  // todo replace with hppc. ObjectLongOpenHashMap (putOrAdd optimization)
  public static final String MAP_COUNTS_FORMAT_ID = "counts";
  public static final ValueFormat<Map<ItemIdentity, Integer>> MAP_ITEM_COUNT_FORMAT =
    new ValueFormat<>(MAP_COUNTS_FORMAT_ID, StructureUtil.<ItemIdentity, Integer>mapType());

  /**
   * This attribute spec is deprecated because non-unique item count and value map can now have
   * parameters (children and leaves).
   */
  @Deprecated
  public static final AttributeSpec<Map<ItemIdentity, Integer>> NON_UNIQUE_ITEMS_SPEC =
    new AttributeSpec<>(NON_UNIQUE_ITEMS, MAP_ITEM_COUNT_FORMAT);

  @SuppressWarnings("unchecked")
  public static <T> ValueFormat<Map<ItemIdentity, T>> nonUniqueValuesValueFormat() {
    return (ValueFormat) MAP_VALUES_FORMAT;
  }
}
