package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.ItemTypeAttributeLoader;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;

public class ItemTypeConstantLoader<A> extends ItemTypeAttributeLoader<A> {
  private final A myValue;

  public ItemTypeConstantLoader(AttributeSpec<A> spec, String itemType, @NotNull A value) {
    super(spec, itemType);
    if (value == null) throw new NullPointerException("value");
    myValue = value;
  }

  @NotNull
  @Override
  public AttributeValue<A> getItemValue(@NotNull StructureRow row, @NotNull Context context) {
    return AttributeValue.of(myValue);
  }
}
