package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;

public abstract class ItemClassAttributeLoader<T, A> extends ItemTypeAttributeLoader<A> {
  private final Class<T> myItemClass;

  public ItemClassAttributeLoader(AttributeSpec<A> spec, Class<T> itemClass, String... itemTypes) {
    super(spec, itemTypes);
    if (itemClass == null) {
      throw new IllegalArgumentException("item class is not defined");
    }
    myItemClass = itemClass;
  }

  @NotNull
  public final AttributeValue<A> getItemValue(@NotNull StructureRow row, @NotNull Context context) {
    T item = row.getItem(myItemClass);
    if (item == null) {
      return AttributeValue.undefined();
    }
    return getValue(item, context);
  }

  protected abstract AttributeValue<A> getValue(@NotNull T item, Context context);
}
