package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.atlassian.annotations.PublicSpi;
import org.jetbrains.annotations.NotNull;

/**
 * <p>An optional interface for bulk attribute preloading. If your {@link AttributeLoader} implements
 * this interface, then Structure will call its {@link #preload(LongSet, ItemForest, AttributeContext)}
 * method once before it starts calling {@code loadValue()} or {@code loadChildrenValues()}.
 */
@PublicSpi
public interface BulkAttributeLoader {
  /**
   * <p>This method is called before all calls to {@code loadValue()} or {@code loadChildrenValues()}
   * in the current calculation. It is given the set of all row IDs for which the values are needed,
   * so that it can load some data more efficiently, e.g. run a JQL query for all relevant issues.
   *
   * <p>The result can be stored inside the loader instance itself or in the provided {@link AttributeContext}.
   *
   * <p>The current loader's dependencies are not yet loaded at the time of the call.
   *
   * @param rowIds The set of row IDs for which attribute values are needed.
   * @param forest The {@link ItemForest} for which attribute values are needed.
   * @param context The {@link AttributeContext context}.
   */
  void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context);
}
