package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * An object that implements {@code RowValues} interface is supplied as a result of attributes calculation by
 * {@link StructureAttributeService}. The interface allows retrieval of values by row ID and attribute specification.
 *
 * @see VersionedRowValues
 * @see StructureAttributeService
 * @see AttributeSpec
 */
@PublicApi
public interface RowValues {
  /**
   * Returns a value for the given row and attribute.
   *
   * @param row row ID
   * @param attribute attribute specification
   * @param <T> value type
   * @return value or {@code null} if the value is missing
   */
  @Nullable
  <T> T get(@Nullable Long row, @Nullable AttributeSpec<T> attribute);

  /**
   * Returns an object that can be used to implement correct value invalidation, in case the value is cached.
   *
   * @param attribute attribute that was requested for value calculation
   * @return the attribute's trail (a trail for non-requested attribute will be empty, but not null)
   */
  @NotNull
  AttributeTrail getTrail(AttributeSpec<?> attribute);
}
